/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.controller.log.ExceptionBundle;
import org.jboss.aerogear.controller.router.MediaType;
import org.jboss.aerogear.controller.router.Responder;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.util.RequestUtils;

public class Responders {
    private final Map<MediaType, Responder> responders = new LinkedHashMap<MediaType, Responder>();

    @Inject
    public Responders(Instance<Responder> responders) {
        for (Responder responder : responders) {
            this.responders.put(responder.getMediaType(), responder);
        }
    }

    public void respond(RouteContext routeContext, Object result) throws Exception {
        Set<String> acceptHeaders = RequestUtils.extractAcceptHeader(routeContext.getRequest());
        Set<MediaType> routeMediaTypes = routeContext.getRoute().produces();
        for (String acceptHeader : acceptHeaders) {
            for (MediaType mediaType : routeMediaTypes) {
                if (!mediaType.getType().equals(acceptHeader) || !this.respond(mediaType, result, routeContext)) continue;
                return;
            }
        }
        if (!acceptHeaders.contains("*/*") && !acceptHeaders.isEmpty()) {
            throw ExceptionBundle.MESSAGES.noResponderForRequestedMediaType(routeContext.getRequest().getHeader("Accept"), this);
        }
        this.respondAny(routeMediaTypes, result, routeContext);
    }

    private boolean respond(MediaType mediaType, Object result, RouteContext routeContext) throws Exception {
        if (this.responders.containsKey(mediaType)) {
            this.responders.get(mediaType).respond(result, routeContext);
            return true;
        }
        return false;
    }

    private void respondAny(Set<MediaType> mediaTypes, Object result, RouteContext routeContext) throws Exception {
        for (MediaType mediaType : mediaTypes) {
            if (this.respond(mediaType, result, routeContext)) break;
        }
    }

    public String toString() {
        return "Responders[" + this.responders + "]";
    }
}

