/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.parameter;

import org.jboss.aerogear.controller.router.parameter.RequestParameter;

public class Parameter<T> {
    private final Type parameterType;
    private final Class<T> type;

    public static <T> Parameter<T> param(Class<T> type) {
        return new Parameter<T>(Type.ENTITY, type);
    }

    public static <T> Parameter<T> param(String name, Class<T> type) {
        return new RequestParameter<T>(name, Type.REQUEST, type);
    }

    public static <T> Parameter<T> param(String name, T defaultValue, Class<T> type) {
        return new RequestParameter<T>(name, Type.REQUEST, defaultValue, type);
    }

    public Parameter(Type parameterType, Class<T> type) {
        this.parameterType = parameterType;
        this.type = type;
    }

    public Type getParameterType() {
        return this.parameterType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "Parameter[type=" + (Object)((Object)this.parameterType) + ", type=" + this.type + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameterType == null ? 0 : this.parameterType.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.parameterType != other.parameterType) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.getName().equals(other.type.getName()));
    }

    public static enum Type {
        REQUEST,
        ENTITY;

    }
}

