/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.router.Consumer;
import org.jboss.aerogear.controller.router.EndpointInvoker;
import org.jboss.aerogear.controller.router.InvocationResult;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.RouteProcessor;
import org.jboss.aerogear.controller.router.rest.pagination.AbstractPaginationStrategy;
import org.jboss.aerogear.controller.router.rest.pagination.Paginated;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationInfo;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationMetadata;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationStrategy;
import org.jboss.aerogear.controller.util.ParameterExtractor;

@Decorator
public class PaginationHandler
implements RouteProcessor {
    private final RouteProcessor delegate;
    private final PaginationStrategy pagingStrategy;
    private final Map<String, Consumer> consumers = new HashMap<String, Consumer>();
    private final EndpointInvoker endpointInvoker;

    @Inject
    public PaginationHandler(@Delegate RouteProcessor delegate, Instance<PaginationStrategy> pagingStrategies, Instance<Consumer> consumers, EndpointInvoker endpointInvoker) {
        this.delegate = delegate;
        this.pagingStrategy = pagingStrategies.isUnsatisfied() ? PaginationHandler.defaultPagingStrategy() : (PaginationStrategy)pagingStrategies.get();
        this.endpointInvoker = endpointInvoker;
        for (Consumer consumer : consumers) {
            this.consumers.put(consumer.mediaType(), consumer);
        }
    }

    @Override
    public InvocationResult process(RouteContext routeContext) throws Exception {
        if (this.hasPaginatedAnnotation(routeContext.getRoute())) {
            Map<String, Object> requestArgs = ParameterExtractor.extractArguments(routeContext, this.consumers);
            PaginationInfo paginationInfo = this.pagingStrategy.createPaginationInfo(routeContext, requestArgs);
            Object[] args = this.pagingStrategy.preInvocation(paginationInfo, requestArgs);
            Collection results = (Collection)this.endpointInvoker.invoke(routeContext, args);
            return new InvocationResult(this.pagingStrategy.postInvocation(results, routeContext, paginationInfo), routeContext);
        }
        return this.delegate.process(routeContext);
    }

    private boolean hasPaginatedAnnotation(Route route) {
        return route.getTargetMethod().getAnnotation(Paginated.class) != null;
    }

    public static PaginationStrategy defaultPagingStrategy() {
        return new AbstractPaginationStrategy(){

            @Override
            public void setResponseHeaders(PaginationMetadata metadata, HttpServletResponse response, int resultSize) {
                for (Map.Entry<String, String> entry : metadata.getHeaders(resultSize).entrySet()) {
                    response.setHeader(entry.getKey(), entry.getValue());
                }
            }
        };
    }
}

