/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import org.jboss.aerogear.controller.util.StringUtils;

public class TypeNameExtractor {
    public String nameFor(Type generic) {
        if (generic instanceof ParameterizedType) {
            return this.nameFor((ParameterizedType)generic);
        }
        if (generic instanceof WildcardType) {
            return this.nameFor((WildcardType)generic);
        }
        if (generic instanceof TypeVariable) {
            return this.nameFor((TypeVariable)generic);
        }
        return this.nameFor((Class)generic);
    }

    private String nameFor(Class<?> raw) {
        if (raw.isArray()) {
            return this.nameFor(raw.getComponentType()) + "List";
        }
        String name = raw.getSimpleName();
        return StringUtils.downCaseFirst(name);
    }

    private String nameFor(TypeVariable<?> variable) {
        return StringUtils.downCaseFirst(variable.getName());
    }

    private String nameFor(WildcardType wild) {
        if (wild.getLowerBounds().length != 0) {
            return this.nameFor(wild.getLowerBounds()[0]);
        }
        return this.nameFor(wild.getUpperBounds()[0]);
    }

    private String nameFor(ParameterizedType type) {
        Class raw = (Class)type.getRawType();
        if (Collection.class.isAssignableFrom(raw)) {
            return this.nameFor(type.getActualTypeArguments()[0]) + "List";
        }
        return this.nameFor(raw);
    }
}

