/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import java.util.LinkedList;
import java.util.List;
import org.jboss.aerogear.controller.router.AeroGearException;
import org.jboss.aerogear.controller.router.MediaType;
import org.jboss.aerogear.controller.router.RouteBuilder;
import org.jboss.aerogear.controller.router.RouteDescriptor;
import org.jboss.aerogear.controller.router.RouteDescriptorAccessor;
import org.jboss.aerogear.controller.router.Routes;
import org.jboss.aerogear.controller.router.RoutingModule;
import org.jboss.aerogear.controller.router.parameter.Parameter;

public abstract class AbstractRoutingModule
implements RoutingModule {
    public static final MediaType JSON = MediaType.JSON;
    public static final MediaType JSP = MediaType.JSP;
    public static final MediaType HTML = MediaType.HTML;
    private final List<RouteBuilder> routes = new LinkedList<RouteBuilder>();

    public abstract void configuration() throws Exception;

    public RouteBuilder route() {
        RouteBuilder route = Routes.route();
        this.routes.add(route);
        return route;
    }

    @Override
    public Routes build() {
        try {
            this.configuration();
        }
        catch (Exception e) {
            throw new AeroGearException(e);
        }
        return Routes.from(this.routes);
    }

    public <T> T param(Class<T> type) {
        this.addParameter(Parameter.param(type));
        return null;
    }

    public String param(String str) {
        this.addParameter(Parameter.param(str, String.class));
        return null;
    }

    public <T> T param(String id, Class<T> type) {
        this.addParameter(Parameter.param(id, type));
        return null;
    }

    public String param(String id, String defaultValue) {
        this.addParameter(Parameter.param(id, defaultValue, String.class));
        return null;
    }

    private void addParameter(Parameter<?> parameter) {
        this.current().addParameter(parameter);
    }

    private RouteDescriptor current() {
        RouteDescriptorAccessor rda = (RouteDescriptorAccessor)((Object)this.routes.get(this.routes.size() - 1));
        return rda.getRouteDescriptor();
    }
}

