/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.log.ExceptionBundle;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.RouteProcessor;
import org.jboss.aerogear.controller.router.Router;
import org.jboss.aerogear.controller.router.Routes;
import org.jboss.aerogear.controller.router.RoutingModule;
import org.jboss.aerogear.controller.util.RequestUtils;

public class DefaultRouter
implements Router {
    private Routes routes;
    private RouteProcessor routeProcessor;

    public DefaultRouter() {
    }

    @Inject
    public DefaultRouter(Instance<RoutingModule> instance, RouteProcessor routeProcessor) {
        if (instance.isUnsatisfied()) {
            throw ExceptionBundle.MESSAGES.noRoutesAvailable();
        }
        this.routes = ((RoutingModule)instance.get()).build();
        this.routeProcessor = routeProcessor;
    }

    @Override
    public boolean hasRouteFor(HttpServletRequest request) {
        return this.routes.hasRouteFor(RequestUtils.extractMethod(request), RequestUtils.extractPath(request), RequestUtils.extractAcceptHeader(request));
    }

    @Override
    public void dispatch(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException {
        try {
            String requestPath = RequestUtils.extractPath(request);
            Route route = this.routes.routeFor(RequestUtils.extractMethod(request), requestPath, RequestUtils.extractAcceptHeader(request));
            this.routeProcessor.process(new RouteContext(route, requestPath, request, response, this.routes));
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }
}

