/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.util;

import br.com.caelum.iogi.Iogi;
import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.spi.DependencyProvider;
import br.com.caelum.iogi.spi.LocaleProvider;
import br.com.caelum.iogi.util.DefaultLocaleProvider;
import br.com.caelum.iogi.util.NullDependencyProvider;
import com.google.common.base.Optional;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.servlet.http.Cookie;
import org.jboss.aerogear.controller.log.AeroGearLogger;
import org.jboss.aerogear.controller.log.ExceptionBundle;
import org.jboss.aerogear.controller.router.Consumer;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.parameter.ConstantParameter;
import org.jboss.aerogear.controller.router.parameter.ReplacementParameter;
import org.jboss.aerogear.controller.router.parameter.RequestParameter;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationInfo;
import org.jboss.aerogear.controller.util.RequestUtils;
import org.jboss.aerogear.controller.util.StringUtils;

public class ParameterExtractor {
    private static final Iogi IOGI = new Iogi((DependencyProvider)new NullDependencyProvider(), (LocaleProvider)new DefaultLocaleProvider());

    public static Map<String, Object> extractArguments(RouteContext routeContext, Map<String, Consumer> consumers) throws Exception {
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>();
        List<org.jboss.aerogear.controller.router.parameter.Parameter<?>> parameters = routeContext.getRoute().getParameters();
        int size = parameters.size();
        block6: for (int i = 0; i < size; ++i) {
            org.jboss.aerogear.controller.router.parameter.Parameter<?> parameter = parameters.get(i);
            switch (parameter.getParameterType()) {
                case ENTITY: {
                    if (PaginationInfo.class.isAssignableFrom(parameter.getType()) || ParameterExtractor.addIfPresent(ParameterExtractor.extractIogiParam(routeContext), "entityParam", argsMap)) continue block6;
                    argsMap.put("entityParam", ParameterExtractor.extractBody(routeContext, parameter, ParameterExtractor.getConsumer(routeContext, consumers, parameter)));
                    continue block6;
                }
                case REQUEST: {
                    RequestParameter rp = (RequestParameter)parameter;
                    ParameterExtractor.extractRequestParam(rp.getName(), rp.getType(), rp.getDefaultValue(), argsMap, routeContext);
                    continue block6;
                }
                case CONSTANT: {
                    ConstantParameter cp = (ConstantParameter)parameter;
                    argsMap.put("constantParam-" + i, cp.getValue());
                    continue block6;
                }
                case REPLACEMENT: {
                    ReplacementParameter replacementParam = (ReplacementParameter)parameter;
                    Map<String, Object> paramsMap = ParameterExtractor.extractRequestParams(replacementParam, routeContext);
                    argsMap.put("replacementParam-" + i, RequestUtils.injectParamValues(replacementParam.getString(), paramsMap));
                }
            }
        }
        return argsMap;
    }

    private static Map<String, Object> extractRequestParam(String paramName, Class<?> type, Optional<?> defaultValue, Map<String, Object> map, RouteContext routeContext) throws Exception {
        if (ParameterExtractor.addIfPresent(ParameterExtractor.extractParam(routeContext, paramName, type), paramName, map)) {
            return map;
        }
        if (ParameterExtractor.addIfPresent(ParameterExtractor.extractHeaderParam(routeContext, paramName), paramName, map)) {
            return map;
        }
        if (ParameterExtractor.addIfPresent(ParameterExtractor.extractCookieParam(routeContext, paramName, type), paramName, map)) {
            return map;
        }
        if (ParameterExtractor.addIfPresent(ParameterExtractor.extractDefaultParam(type, defaultValue), paramName, map)) {
            return map;
        }
        if (ParameterExtractor.addIfPresent(ParameterExtractor.extractPathParam(routeContext, paramName, type), paramName, map)) {
            return map;
        }
        throw ExceptionBundle.MESSAGES.missingParameterInRequest(paramName);
    }

    private static Map<String, Object> extractRequestParams(ReplacementParameter<?> replacementParam, RouteContext routeContext) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String paramName : replacementParam.getParamNames()) {
            ParameterExtractor.extractRequestParam(paramName, String.class, Optional.absent(), map, routeContext);
        }
        return map;
    }

    private static Optional<?> extractDefaultParam(Class<?> type, Optional<?> defaultValue) throws Exception {
        if (defaultValue.isPresent()) {
            return Optional.of((Object)ParameterExtractor.createInstance(type, defaultValue.get().toString()));
        }
        return Optional.absent();
    }

    private static Object extractBody(RouteContext routeContext, org.jboss.aerogear.controller.router.parameter.Parameter<?> parameter, Consumer consumer) {
        return consumer.unmarshall(routeContext.getRequest(), parameter.getType());
    }

    private static Consumer getConsumer(RouteContext routeContext, Map<String, Consumer> consumers, org.jboss.aerogear.controller.router.parameter.Parameter<?> parameter) {
        Set<String> mediaTypes = routeContext.getRoute().consumes();
        Optional<String> contentType = ParameterExtractor.extractContentType(routeContext);
        if (contentType.isPresent()) {
            Consumer consumer = consumers.get(contentType.get());
            if (consumer != null) {
                return consumer;
            }
        } else {
            for (String mediaType : mediaTypes) {
                Consumer consumer = consumers.get(mediaType);
                if (consumer == null) continue;
                return consumer;
            }
        }
        throw ExceptionBundle.MESSAGES.noConsumerForMediaType(parameter, consumers.values(), mediaTypes);
    }

    private static Optional<String> extractContentType(RouteContext routeContext) {
        String contentType = routeContext.getRequest().getContentType();
        if (contentType != null) {
            try {
                MimeType mimeType = new MimeType(contentType);
                return Optional.of((Object)mimeType.getBaseType());
            }
            catch (MimeTypeParseException e) {
                throw new RuntimeException("Error parsing content-type " + contentType, e);
            }
        }
        return Optional.absent();
    }

    public static Optional<?> extractPathParam(RouteContext routeContext, RequestParameter<?> param) throws Exception {
        return ParameterExtractor.extractPathParam(routeContext, param.getName(), param.getType());
    }

    public static Optional<?> extractPathParam(RouteContext routeContext, String paramName, Class<?> type) throws Exception {
        String value;
        String requestPath = routeContext.getRequestPath();
        Map<String, String> pathParams = RequestUtils.mapPathParams(requestPath, routeContext.getRoute().getPath());
        if (pathParams.containsKey(paramName) && (value = pathParams.get(paramName)) != null) {
            return Optional.of((Object)ParameterExtractor.createInstance(type, pathParams.get(paramName)));
        }
        return Optional.absent();
    }

    public static Optional<?> extractIogiParam(RouteContext routeContext) {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        for (Map.Entry entry : routeContext.getRequest().getParameterMap().entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value.length == 1) {
                parameters.add(new Parameter((String)entry.getKey(), value[0]));
                continue;
            }
            AeroGearLogger.LOGGER.multivaluedParamsUnsupported();
        }
        if (!parameters.isEmpty()) {
            Class<?>[] parameterTypes = routeContext.getRoute().getTargetMethod().getParameterTypes();
            Class<?> parameterType = parameterTypes[0];
            Target target = Target.create(parameterType, (String)StringUtils.downCaseFirst(parameterType.getSimpleName()));
            return Optional.fromNullable((Object)IOGI.instantiate(target, parameters.toArray(new Parameter[parameters.size()])));
        }
        return Optional.absent();
    }

    private static boolean addIfPresent(Optional<?> op, String paramName, Map<String, Object> args) {
        if (op.isPresent()) {
            args.put(paramName, op.get());
            return true;
        }
        return false;
    }

    private static Optional<?> extractHeaderParam(RouteContext routeContext, String paramName) {
        return Optional.fromNullable((Object)routeContext.getRequest().getHeader(paramName));
    }

    private static Optional<?> extractCookieParam(RouteContext routeContext, String paramName, Class<?> type) throws Exception {
        Cookie[] cookies = routeContext.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(paramName)) continue;
                return Optional.fromNullable((Object)ParameterExtractor.createInstance(type, cookie.getValue()));
            }
        }
        return Optional.absent();
    }

    private static Optional<?> extractParam(RouteContext routeContext, String name, Class<?> type) throws Exception {
        String[] values = (String[])routeContext.getRequest().getParameterMap().get(name);
        if (values != null) {
            if (values.length == 1) {
                return Optional.of((Object)ParameterExtractor.createInstance(type, values[0]));
            }
            throw ExceptionBundle.MESSAGES.multivaluedParamsUnsupported(name);
        }
        return Optional.absent();
    }

    private static Object createInstance(Class<?> type, String arg) throws Exception {
        Constructor<?> constructor = type.getDeclaredConstructor(String.class);
        return constructor.newInstance(arg);
    }
}

