/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jboss.aerogear.crypto.Util;
import org.jboss.aerogear.crypto.password.DefaultPbkdf2;
import org.jboss.aerogear.crypto.password.Pbkdf2;

public class AeroGearCrypto {
    public static final String PROVIDER;
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int DERIVED_KEY_LENGTH = 256;
    public static final int ITERATIONS = 20000;
    public static final int MINIMUM_SALT_LENGTH = 16;
    public static final int MINIMUM_ITERATION = 10000;
    public static final int MINIMUM_SECRET_KEY_SIZE = 32;
    public static final int TAG_LENGTH = 128;
    public static final String HMAC_ALGORITHM = "HmacSHA256";
    public static final String ECDH_ALGORITHM_NAME = "ECDH";
    public static final String ECDSA_ALGORITHM_NAME = "ECDSA";
    public static final String DEFAULT_CURVE_NAME = "P-256";
    public static final String DEFAULT_ECDSA_SHA = "SHA256withECDSA";
    public static final String DEFAULT_SHA_ALGORITHM = "SHA-256";

    private AeroGearCrypto() {
    }

    public static Pbkdf2 pbkdf2() {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
            return new DefaultPbkdf2(keyFactory);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String string = PROVIDER = Util.isAndroid() ? "SC" : "BC";
        if (Util.isAndroid()) {
            Provider spongyCastleProvider = null;
            try {
                spongyCastleProvider = (Provider)Class.forName("org.spongycastle.jce.provider.BouncyCastleProvider").newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            Security.insertProviderAt(spongyCastleProvider, 1);
        } else if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static enum Mode {
        GCM("GCM", Padding.NONE);

        private final Padding padding;
        private String mode;

        private Mode(String mode, Padding padding) {
            this.mode = mode;
            this.padding = padding;
        }

        public String toString() {
            return String.format("%s/%s", new Object[]{this.mode, this.padding});
        }
    }

    public static enum Padding {
        NONE("NoPadding"),
        PKCS7("PKCS7Padding");

        private final String padding;

        private Padding(String padding) {
            this.padding = padding;
        }

        public String toString() {
            return this.padding;
        }
    }

    public static enum Algorithm {
        AES("AES", 256);

        private String name;
        private int keySize;

        private Algorithm(String name, int keySize) {
            this.name = name;
            this.keySize = keySize;
        }

        public String toString() {
            return this.name;
        }

        public int getKeySize() {
            return this.keySize;
        }
    }
}

