/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jboss.aerogear.AeroGearCrypto;
import org.jboss.aerogear.crypto.BlockCipher;
import org.jboss.aerogear.crypto.Util;
import org.jboss.aerogear.crypto.encoders.Encoder;
import org.jboss.aerogear.crypto.keys.PrivateKey;

public class CryptoBox {
    private byte[] key;
    private AEADBlockCipher cipher;
    private byte[] authData;

    public CryptoBox(byte[] key) {
        Util.checkLength(key, 32);
        this.cipher = BlockCipher.getInstance();
        this.key = key;
    }

    public CryptoBox(PrivateKey key) {
        this(key.toBytes());
    }

    public CryptoBox(String key, Encoder encoder) {
        this(encoder.decode(key));
    }

    public CryptoBox(java.security.PrivateKey privateKey, PublicKey publicKey) {
        this.cipher = BlockCipher.getInstance();
        this.key = this.generateSecret(privateKey, publicKey);
        Util.checkLength(this.key, 32);
    }

    private byte[] generateSecret(java.security.PrivateKey privateKey, PublicKey publicKey) {
        MessageDigest hash = null;
        KeyAgreement keyAgree = null;
        try {
            hash = MessageDigest.getInstance("SHA-256", AeroGearCrypto.PROVIDER);
            keyAgree = KeyAgreement.getInstance("ECDH", AeroGearCrypto.PROVIDER);
            keyAgree.init(privateKey);
            keyAgree.doPhase(publicKey, true);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Fail: ", e);
        }
        return hash.digest(keyAgree.generateSecret());
    }

    public byte[] encrypt(byte[] IV, byte[] message) throws RuntimeException {
        AEADParameters aeadParams = new AEADParameters(new KeyParameter(this.key), 128, IV, this.authData);
        this.cipher.init(true, (CipherParameters)aeadParams);
        byte[] cipherText = Util.newBuffer(this.cipher.getOutputSize(message.length));
        int outputOffset = this.cipher.processBytes(message, 0, message.length, cipherText, 0);
        try {
            this.cipher.doFinal(cipherText, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException("Error: ", e);
        }
        return cipherText;
    }

    public byte[] encrypt(String IV, String message, Encoder encoder) {
        return this.encrypt(encoder.decode(IV), encoder.decode(message));
    }

    public byte[] decrypt(byte[] IV, byte[] cipherText) throws RuntimeException {
        AEADParameters aeadParams = new AEADParameters(new KeyParameter(this.key), 128, IV, this.authData);
        this.cipher.init(false, (CipherParameters)aeadParams);
        byte[] buffer = Util.newByteArray(cipherText);
        byte[] plainText = Util.newBuffer(this.cipher.getOutputSize(cipherText.length));
        int outputOffset = this.cipher.processBytes(buffer, 0, buffer.length, plainText, 0);
        try {
            this.cipher.doFinal(plainText, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException("Error: ", e);
        }
        return plainText;
    }

    public byte[] decrypt(String IV, String cipherText, Encoder encoder) {
        return this.decrypt(encoder.decode(IV), encoder.decode(cipherText));
    }
}

