/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.crypto.password;

import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jboss.aerogear.crypto.RandomUtils;
import org.jboss.aerogear.crypto.Util;
import org.jboss.aerogear.crypto.password.Pbkdf2;

public class DefaultPbkdf2
implements Pbkdf2 {
    private byte[] salt;
    private SecretKeyFactory secretKeyFactory;

    public DefaultPbkdf2(SecretKeyFactory keyFactory) {
        this.secretKeyFactory = keyFactory;
    }

    @Override
    public byte[] encrypt(String password, byte[] salt, int iterations) throws InvalidKeySpecException {
        this.salt = Util.checkLength(salt, 16);
        iterations = Util.checkSize(iterations, 10000);
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, 256);
        return this.secretKeyFactory.generateSecret(spec).getEncoded();
    }

    @Override
    public SecretKey generateSecretKey(String password, byte[] salt, int iterations) throws InvalidKeySpecException {
        this.salt = Util.checkLength(salt, 16);
        iterations = Util.checkSize(iterations, 10000);
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, 256);
        return this.secretKeyFactory.generateSecret(spec);
    }

    @Override
    public byte[] encrypt(String password, byte[] salt) throws InvalidKeySpecException {
        return this.encrypt(password, salt, 20000);
    }

    @Override
    public byte[] encrypt(String password) throws InvalidKeySpecException {
        byte[] salt = RandomUtils.randomBytes();
        return this.encrypt(password, salt);
    }

    @Override
    public SecretKey generateSecretKey(String password) throws InvalidKeySpecException {
        byte[] salt = RandomUtils.randomBytes();
        return this.generateSecretKey(password, salt, 20000);
    }

    @Override
    public boolean validate(String password, byte[] encryptedPassword, byte[] salt) throws InvalidKeySpecException {
        byte[] attempt = this.encrypt(password, salt);
        return Arrays.equals(encryptedPassword, attempt);
    }

    public byte[] getSalt() {
        return this.salt;
    }
}

