/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketbox.authz;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.model.AeroGearUser;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.PlainTextPassword;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.User;

@ApplicationScoped
public class GrantConfiguration
implements IdentityManagement.GrantMethods {
    @Inject
    private IdentityManager identityManager;
    private List<Role> list;

    public GrantConfiguration roles(String[] roles) {
        this.list = new ArrayList<Role>();
        for (String role : roles) {
            Role newRole = this.identityManager.getRole(role);
            if (newRole == null) {
                newRole = new SimpleRole(role);
                this.identityManager.add((IdentityType)newRole);
            }
            this.list.add(newRole);
        }
        return this;
    }

    public void to(AeroGearUser aeroGearUser) {
        User picketLinkUser = this.identityManager.getUser(aeroGearUser.getUsername());
        this.identityManager.updateCredential((Agent)picketLinkUser, (Object)new PlainTextPassword(aeroGearUser.getPassword()));
        for (Role role : this.list) {
            this.identityManager.grantRole((IdentityType)picketLinkUser, role);
        }
    }
}

