/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketbox.authz;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.model.AeroGearUser;
import org.jboss.aerogear.security.picketbox.authz.GrantConfiguration;
import org.jboss.aerogear.security.picketbox.util.Converter;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;

@ApplicationScoped
public class IdentityManagementImpl
implements IdentityManagement {
    @Inject
    private IdentityManager identityManager;
    @Inject
    private GrantConfiguration grantConfiguration;

    public IdentityManagement.GrantMethods grant(String ... roles) {
        return this.grantConfiguration.roles(roles);
    }

    public AeroGearUser get(String id) throws RuntimeException {
        User user = this.identityManager.getUser(id);
        if (user == null) {
            throw new RuntimeException("User do not exist");
        }
        return Converter.convertToAerogearUser(this.identityManager.getUser(id));
    }

    public void remove(AeroGearUser aeroGearUser) {
        this.identityManager.remove((IdentityType)this.identityManager.getUser(aeroGearUser.getUsername()));
    }

    public List<AeroGearUser> findAllByRole(String role) {
        ArrayList<AeroGearUser> aerogearUsers = new ArrayList<AeroGearUser>();
        IdentityQuery query = this.identityManager.createQuery(User.class);
        query.setParameter(User.HAS_ROLE, (Object[])new String[]{role});
        List result = query.getResultList();
        for (User user : result) {
            aerogearUsers.add(Converter.convertToAerogearUser(user));
        }
        return aerogearUsers;
    }

    public void create(AeroGearUser aeroGearUser) {
        SimpleUser picketLinkUser = new SimpleUser(aeroGearUser.getUsername());
        picketLinkUser.setEmail(aeroGearUser.getEmail());
        picketLinkUser.setFirstName(aeroGearUser.getFirstName());
        picketLinkUser.setLastName(aeroGearUser.getLastName());
        this.identityManager.add((IdentityType)picketLinkUser);
    }
}

