/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketbox.config;

import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.picketbox.core.identity.impl.JPAIdentityStoreContext;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.PlainTextPassword;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;

@Singleton
@Startup
public class PicketBoxLoadUsers {
    @PersistenceContext(unitName="picketbox-default", type=PersistenceContextType.EXTENDED)
    private EntityManager entityManager;
    @Inject
    private IdentityManager identityManager;

    @PostConstruct
    public void create() {
        JPAIdentityStoreContext.set((EntityManager)this.entityManager);
        SimpleUser user = new SimpleUser("john");
        user.setEmail("john@doe.com");
        user.setFirstName("John");
        user.setLastName("Doe");
        this.identityManager.add((IdentityType)user);
        this.identityManager.updateCredential((Agent)user, (Object)new PlainTextPassword("123"));
        SimpleRole roleDeveloper = new SimpleRole("simple");
        SimpleRole roleAdmin = new SimpleRole("admin");
        this.identityManager.add((IdentityType)roleDeveloper);
        this.identityManager.add((IdentityType)roleAdmin);
        this.identityManager.grantRole((IdentityType)user, (Role)roleDeveloper);
        this.identityManager.grantRole((IdentityType)user, (Role)roleAdmin);
        JPAIdentityStoreContext.clear();
    }
}

