/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketbox.idm;

import java.io.Serializable;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.aerogear.security.auth.Secret;
import org.jboss.aerogear.security.auth.Token;
import org.jboss.aerogear.security.idm.AuthenticationKeyProvider;
import org.jboss.aerogear.security.otp.api.Base32;
import org.picketbox.cdi.PicketBoxIdentity;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;

public class AuthenticationKeyProviderImpl
implements AuthenticationKeyProvider {
    private static final String IDM_SECRET_ATTRIBUTE = "serial";
    @Inject
    private PicketBoxIdentity identity;
    @Inject
    private IdentityManager identityManager;

    @Produces
    @Token
    public String getToken() {
        String id = null;
        if (this.identity.isLoggedIn()) {
            id = this.identity.getUserContext().getSession().getId().getId().toString();
        }
        return id;
    }

    @Produces
    @Secret
    public String getSecret() {
        User user = this.identity.getUserContext().getUser();
        Attribute secret = user.getAttribute(IDM_SECRET_ATTRIBUTE);
        if (secret == null) {
            secret = new Attribute(IDM_SECRET_ATTRIBUTE, (Serializable)((Object)Base32.random()));
            user.setAttribute(secret);
            this.identityManager.update((IdentityType)user);
        }
        return (String)((Object)secret.getValue());
    }
}

