/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketlink.auth;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.aerogear.security.auth.AuthenticationManager;
import org.jboss.aerogear.security.exception.AeroGearSecurityException;
import org.jboss.aerogear.security.exception.HttpStatus;
import org.jboss.aerogear.security.model.AeroGearUser;
import org.picketlink.Identity;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.credential.Password;

@ApplicationScoped
public class AuthenticationManagerImpl
implements AuthenticationManager {
    @Inject
    private Identity identity;
    @Inject
    private DefaultLoginCredentials credentials;

    public boolean login(AeroGearUser aeroGearUser) {
        this.credentials.setUserId(aeroGearUser.getUsername());
        this.credentials.setCredential((Object)new Password(aeroGearUser.getPassword()));
        if (this.identity.login() != Identity.AuthenticationResult.SUCCESS) {
            throw new AeroGearSecurityException(HttpStatus.AUTHENTICATION_FAILED);
        }
        return false;
    }

    public void logout() {
        this.onAuthenticationFailure();
        this.identity.logout();
    }

    private void onAuthenticationFailure() {
        if (!this.identity.isLoggedIn()) {
            throw new AeroGearSecurityException(HttpStatus.AUTHENTICATION_FAILED);
        }
    }
}

