/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketlink.idm;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.aerogear.security.auth.LoggedUser;
import org.jboss.aerogear.security.auth.Roles;
import org.jboss.aerogear.security.idm.AeroGearCredential;
import org.picketlink.Identity;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.query.IdentityQuery;

public class AeroGearCredentialImpl
implements AeroGearCredential {
    @Inject
    private Identity identity;
    @Inject
    private IdentityManager identityManager;

    @Produces
    @LoggedUser
    public String getLogin() {
        String id = null;
        if (this.identity.isLoggedIn()) {
            id = this.identity.getUser().getLoginName();
        }
        return id;
    }

    public boolean hasRoles(Set<String> roles) {
        if (this.identity.isLoggedIn()) {
            for (String role : roles) {
                if (!this.identityManager.hasRole((IdentityType)this.identity.getUser(), this.identityManager.getRole(role))) continue;
                return true;
            }
        }
        return false;
    }

    @Produces
    @Roles
    public List<String> getRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        if (this.identity.isLoggedIn()) {
            IdentityQuery query = this.identityManager.createIdentityQuery(Role.class);
            query.setParameter(Role.ROLE_OF, new Object[]{this.identity.getUser()});
            for (Role role : query.getResultList()) {
                roles.add(role.getName());
            }
        }
        return roles;
    }
}

