/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketlink.idm;

import java.io.Serializable;
import java.util.UUID;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.aerogear.security.auth.Secret;
import org.jboss.aerogear.security.auth.Token;
import org.jboss.aerogear.security.idm.AuthenticationKeyProvider;
import org.jboss.aerogear.security.otp.api.Base32;
import org.picketlink.Identity;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.User;

public class AuthenticationKeyProviderImpl
implements AuthenticationKeyProvider {
    private static final String IDM_SECRET_ATTRIBUTE = "serial";
    private static final String TOKEN_ATTRIBUTE = "token";
    @Inject
    private Identity identity;
    @Inject
    private IdentityManager identityManager;

    @Produces
    @Secret
    public String getSecret() {
        User user = this.identity.getUser();
        Attribute secret = user.getAttribute(IDM_SECRET_ATTRIBUTE);
        if (secret == null) {
            secret = new Attribute(IDM_SECRET_ATTRIBUTE, (Serializable)((Object)Base32.random()));
            user.setAttribute(secret);
            this.identityManager.update((IdentityType)user);
        }
        return (String)((Object)secret.getValue());
    }

    @Produces
    @Token
    public String getToken() {
        User user = this.identity.getUser();
        Attribute token = user.getAttribute(TOKEN_ATTRIBUTE);
        if (token == null) {
            token = new Attribute(TOKEN_ATTRIBUTE, (Serializable)((Object)UUID.randomUUID().toString()));
            user.setAttribute(token);
            this.identityManager.update((IdentityType)user);
        }
        return (String)((Object)token.getValue());
    }
}

