/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketlink.authz;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.model.AeroGearUser;
import org.jboss.aerogear.security.picketlink.authz.GrantConfiguration;
import org.jboss.aerogear.security.picketlink.util.Converter;
import org.picketlink.Identity;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;

@ApplicationScoped
public class IdentityManagementImpl
implements IdentityManagement {
    @Inject
    private IdentityManager identityManager;
    @Inject
    private GrantConfiguration grantConfiguration;
    @Inject
    private Identity identity;

    public IdentityManagement.GrantMethods grant(String ... roles) {
        return this.grantConfiguration.roles(roles);
    }

    public AeroGearUser get(String id) throws RuntimeException {
        User user = this.identityManager.getUser(id);
        if (user == null) {
            throw new RuntimeException("User do not exist");
        }
        return Converter.convertToAerogearUser(this.identityManager.getUser(id));
    }

    public void remove(AeroGearUser aeroGearUser) {
        if (this.isLoggedIn(aeroGearUser)) {
            throw new RuntimeException("User is logged in");
        }
        this.identityManager.remove((IdentityType)this.identityManager.getUser(aeroGearUser.getUsername()));
    }

    public List<AeroGearUser> findAllByRole(String roleName) {
        Role role = this.identityManager.getRole(roleName);
        ArrayList<AeroGearUser> aerogearUsers = new ArrayList<AeroGearUser>();
        IdentityQuery query = this.identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{role});
        List result = query.getResultList();
        for (User user : result) {
            aerogearUsers.add(Converter.convertToAerogearUser(user));
        }
        return aerogearUsers;
    }

    public void create(AeroGearUser aeroGearUser) {
        SimpleUser picketLinkUser = new SimpleUser(aeroGearUser.getUsername());
        picketLinkUser.setEmail(aeroGearUser.getEmail());
        picketLinkUser.setFirstName(aeroGearUser.getFirstName());
        picketLinkUser.setLastName(aeroGearUser.getLastName());
        this.identityManager.add((IdentityType)picketLinkUser);
        this.identityManager.updateCredential((Agent)picketLinkUser, (Object)new Password(aeroGearUser.getPassword()));
    }

    private boolean isLoggedIn(AeroGearUser aeroGearUser) {
        return this.identity.isLoggedIn() && this.identity.getUser().getLoginName().equals(aeroGearUser.getUsername());
    }
}

