/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketlink.auth;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.aerogear.security.auth.AuthenticationManager;
import org.jboss.aerogear.security.exception.AeroGearSecurityException;
import org.jboss.aerogear.security.exception.HttpStatus;
import org.jboss.aerogear.security.picketlink.auth.CredentialMatcher;
import org.picketlink.Identity;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.model.User;

@ApplicationScoped
public class AuthenticationManagerImpl
implements AuthenticationManager<User> {
    @Inject
    private Identity identity;
    @Inject
    private DefaultLoginCredentials credentials;
    @Inject
    private IdentityManager identityManager;
    @Inject
    private CredentialMatcher credentialMatcher;

    public boolean login(User user, String password) {
        this.credentials.setUserId(user.getLoginName());
        this.credentials.setCredential((Object)new Password(password));
        this.credentialMatcher.validate(user, password);
        if (this.credentialMatcher.hasExpired()) {
            throw new AeroGearSecurityException(HttpStatus.CREDENTIAL_HAS_EXPIRED);
        }
        if (this.identity.login() != Identity.AuthenticationResult.SUCCESS) {
            throw new AeroGearSecurityException(HttpStatus.AUTHENTICATION_FAILED);
        }
        return true;
    }

    public void logout() {
        this.onAuthenticationFailure();
        this.identity.logout();
    }

    private void onAuthenticationFailure() {
        if (!this.identity.isLoggedIn()) {
            throw new AeroGearSecurityException(HttpStatus.AUTHENTICATION_FAILED);
        }
    }
}

