/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketlink.authz;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.picketlink.Identity;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.sample.Role;
import org.picketlink.idm.model.sample.SampleModel;
import org.picketlink.idm.model.sample.User;

@ApplicationScoped
public class GrantConfiguration
implements IdentityManagement.GrantMethods<User> {
    @Inject
    private IdentityManager identityManager;
    @Inject
    private Identity identity;
    @Inject
    private PartitionManager partitionManager;
    private List<Role> list;

    public GrantConfiguration roles(String[] roles) {
        this.list = new ArrayList<Role>();
        for (String role : roles) {
            Role newRole = SampleModel.getRole((IdentityManager)this.identityManager, (String)role);
            if (newRole == null) {
                newRole = new Role(role);
                this.identityManager.add((IdentityType)newRole);
            }
            this.list.add(newRole);
        }
        return this;
    }

    public GrantConfiguration revoke(String ... roles) {
        this.list = new ArrayList<Role>();
        if (this.identity.isLoggedIn()) {
            for (String role : roles) {
                Role retrievedRole = SampleModel.getRole((IdentityManager)this.identityManager, (String)role);
                if (retrievedRole == null || !SampleModel.hasRole((RelationshipManager)this.partitionManager.createRelationshipManager(), (IdentityType)this.identity.getAccount(), (Role)retrievedRole)) continue;
                this.list.add(retrievedRole);
            }
        }
        return this;
    }

    public void to(User user) {
        for (Role role : this.list) {
            SampleModel.revokeRole((RelationshipManager)this.partitionManager.createRelationshipManager(), (IdentityType)user, (Role)role);
        }
    }

    public void to(String username) {
        User picketLinkUser = SampleModel.getUser((IdentityManager)this.identityManager, (String)username);
        for (Role role : this.list) {
            SampleModel.grantRole((RelationshipManager)this.partitionManager.createRelationshipManager(), (IdentityType)picketLinkUser, (Role)role);
        }
    }
}

