/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.shiro.auth;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.crypto.hash.Sha512Hash;
import org.apache.shiro.subject.Subject;
import org.jboss.aerogear.security.auth.AuthenticationManager;
import org.jboss.aerogear.security.auth.SessionId;
import org.jboss.aerogear.security.shiro.model.User;

@ApplicationScoped
public class AuthenticationManagerImpl
implements AuthenticationManager<User> {
    @Inject
    private Subject subject;
    @SessionId
    @Produces
    private Serializable sessionId;

    public boolean login(User user, String password) {
        UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), new Sha512Hash((Object)password).toHex());
        this.subject.login((AuthenticationToken)token);
        if (!this.subject.isAuthenticated()) {
            throw new RuntimeException("Authentication failed");
        }
        this.sessionId = this.subject.getSession().getId();
        return true;
    }

    public void logout() {
        this.subject.logout();
    }
}

