/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.shiro.authz;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.apache.shiro.crypto.hash.Sha512Hash;
import org.apache.shiro.subject.Subject;
import org.jboss.aerogear.security.auth.LoggedUser;
import org.jboss.aerogear.security.auth.Secret;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.otp.api.Base32;
import org.jboss.aerogear.security.shiro.authz.GrantConfiguration;
import org.jboss.aerogear.security.shiro.model.User;

@ApplicationScoped
public class IdentityManagementImpl
implements IdentityManagement<User> {
    @Inject
    private EntityManager entityManager;
    @Inject
    private GrantConfiguration grantConfiguration;
    @Inject
    private Subject subject;

    public IdentityManagement.GrantMethods grant(String ... roles) {
        return this.grantConfiguration.roles(roles);
    }

    public User findByUsername(String username) throws RuntimeException {
        User user = (User)this.entityManager.createNamedQuery("User.findByUsername", User.class).setParameter("username", (Object)username).getSingleResult();
        if (user == null) {
            throw new RuntimeException("AeroGearUser do not exist");
        }
        return user;
    }

    public User findById(long id) throws RuntimeException {
        return (User)this.entityManager.find(User.class, (Object)id);
    }

    public void remove(String username) {
        User user = (User)this.entityManager.createNamedQuery("User.findByUsername", User.class).setParameter("username", (Object)username).getSingleResult();
        if (user == null) {
            throw new RuntimeException("AeroGearUser do not exist");
        }
        this.entityManager.remove((Object)user);
    }

    public void create(User user, String password) {
        User newUser = new User(user.getUsername(), new Sha512Hash((Object)password).toHex());
        this.entityManager.persist((Object)newUser);
    }

    @Produces
    @Secret
    public String getSecret() {
        Long id = (Long)this.subject.getPrincipal();
        User user = (User)this.entityManager.find(User.class, (Object)id);
        if (user.getSecret() == null) {
            user.setSecret(Base32.random());
            this.entityManager.merge((Object)user);
        }
        return user.getSecret();
    }

    @Produces
    @LoggedUser
    public String getLogin() {
        Long id = (Long)this.subject.getPrincipal();
        User user = (User)this.entityManager.find(User.class, (Object)id);
        return user.getUsername();
    }

    public boolean hasRoles(Set<String> roles) {
        return this.subject.hasAllRoles(roles);
    }

    public List<User> findAllByRole(String roleName) {
        return new ArrayList<User>();
    }
}

