/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.shiro.authz;

import javax.inject.Inject;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.crypto.hash.Sha512Hash;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.shiro.model.Role;
import org.jboss.aerogear.security.shiro.model.User;

public class SecurityRealm
extends AuthorizingRealm {
    @Inject
    private IdentityManagement identityManagerment;

    public SecurityRealm() {
        this.setName("SecurityRealm");
        this.setCredentialsMatcher((CredentialsMatcher)new HashedCredentialsMatcher("SHA-512"));
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authToken;
        User user = (User)this.identityManagerment.findByUsername(token.getUsername());
        if (user != null) {
            return new SimpleAuthenticationInfo((Object)user.getId(), (Object)new Sha512Hash((Object)user.getPassword()), this.getName());
        }
        throw new RuntimeException("Authentication failed");
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        try {
            Long userId = (Long)principals.fromRealm(this.getName()).iterator().next();
            User user = (User)this.identityManagerment.findById(userId.longValue());
            if (user != null) {
                SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
                for (Role role : user.getRoles()) {
                    info.addRole(role.getName());
                    info.addStringPermissions(role.getPermissions());
                }
                return info;
            }
            throw new RuntimeException("Not authorized");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authorization has failed");
        }
    }
}

