/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.security.filter.StrictTransportConfig;

public class StrictTransportFilter
implements Filter {
    public static final String LOCATION = "Location";
    public static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
    private StrictTransportConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = new StrictTransportConfig(filterConfig);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse request = (HttpServletResponse)servletResponse;
        HttpServletRequest response = (HttpServletRequest)servletRequest;
        if (!StrictTransportFilter.isHttpsEnabled(response)) {
            request.addHeader(LOCATION, this.config.getLocation());
            request.setStatus(301);
        } else {
            request.addHeader(STRICT_TRANSPORT_SECURITY, this.config.getMaxAge());
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    private static boolean isHttpsEnabled(HttpServletRequest httpServletRequest) {
        String HTTPS = "https";
        return httpServletRequest.getScheme().equals("https");
    }
}

