/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.rest.filter;

import java.io.IOException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.security.auth.Token;
import org.jboss.aerogear.security.authz.AuthorizationManager;

@WebFilter(filterName="SecurityFilter", urlPatterns={"/auth/*"})
public class SecurityServletFilter
implements Filter {
    private static final String AUTH_TOKEN = "Auth-Token";
    @Inject
    private AuthorizationManager manager;
    @Inject
    @Token
    private Instance<String> credential;

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String token = httpServletRequest.getHeader(AUTH_TOKEN);
        if (token != null && token.isEmpty() && !this.manager.validate(token)) {
            httpServletResponse.setStatus(401);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

