/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.rest.service;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.security.auth.AuthenticationManager;
import org.jboss.aerogear.security.auth.LoggedUser;
import org.jboss.aerogear.security.auth.Secret;
import org.jboss.aerogear.security.auth.Token;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.model.AeroGearUser;
import org.jboss.aerogear.security.otp.Totp;
import org.jboss.aerogear.security.rest.service.AuthenticationService;

@Stateless
@TransactionAttribute
public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final String AUTH_TOKEN = "Auth-Token";
    private static final String AUTH_SECRET = "Auth-Secret";
    public static final String DEFAULT_ROLE = "admin";
    @Inject
    private AuthenticationManager authenticationManager;
    @Inject
    private IdentityManagement configuration;
    @Inject
    @Token
    private Instance<String> token;
    @Inject
    @Secret
    private Instance<String> secret;
    @Inject
    @LoggedUser
    private Instance<String> loggedUser;

    @Override
    public Response login(AeroGearUser aeroGearUser) {
        this.authenticationManager.login(aeroGearUser);
        return Response.ok((Object)aeroGearUser).header(AUTH_TOKEN, this.token.get()).build();
    }

    @Override
    public Response otpLogin(AeroGearUser aeroGearUser) {
        this.authenticationManager.login(aeroGearUser);
        return Response.ok((Object)aeroGearUser).header(AUTH_TOKEN, this.token.get()).build();
    }

    @Override
    public Response register(AeroGearUser aeroGearUser) {
        this.configuration.grant(DEFAULT_ROLE).to(aeroGearUser);
        this.authenticationManager.login(aeroGearUser);
        return Response.ok((Object)aeroGearUser).header(AUTH_TOKEN, this.token.get()).build();
    }

    @Override
    public void logout() {
        this.authenticationManager.logout();
    }

    @Override
    public Response getSecret() {
        Totp totp = new Totp((String)this.secret.get());
        AeroGearUser userInfo = new AeroGearUser();
        userInfo.setUri(totp.uri((String)this.loggedUser.get()));
        return Response.ok((Object)userInfo).build();
    }
}

