/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.exception;

import javax.ws.rs.core.Response;

public enum HttpStatus {
    AUTHENTICATION_FAILED("User authentication failed", Response.Status.UNAUTHORIZED.getStatusCode()),
    PASSWORD_RESET_FAILED("Password reset failed", Response.Status.UNAUTHORIZED.getStatusCode()),
    CREDENTIAL_NOT_FOUND("Credentials could not be found", Response.Status.FORBIDDEN.getStatusCode()),
    ALREADY_LOGGED_IN("Credentials already logged in", Response.Status.NOT_ACCEPTABLE.getStatusCode()),
    CREDENTIAL_HAS_EXPIRED("Credential has expired", Response.Status.FORBIDDEN.getStatusCode());

    private String message;
    private int status;

    private HttpStatus(String message) {
        this.message = message;
    }

    private HttpStatus(String message, int status) {
        this.message = message;
        this.status = status;
    }

    public int getCode() {
        return this.status;
    }

    public String toString() {
        return String.format("{message : %s }", this.message);
    }

    public String getMessage() {
        return this.message;
    }
}

