/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.web.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;
import javax.servlet.FilterConfig;

public class PasswordHandlerConfig {
    private static final String CONFIG_FILE = "META-INF/config.properties";
    private static final Properties props = new Properties();
    private static String applicationUrl;
    private static String redirectPage;

    public static void loadFilterConfig(FilterConfig config) {
        applicationUrl = config.getInitParameter("url");
        redirectPage = config.getInitParameter("redirect-page");
    }

    public static String uri(String id) {
        try {
            return String.format(applicationUrl + "%s%s", "reset?id=", URLEncoder.encode(id, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String getSecret() {
        return props.getProperty("config.secret");
    }

    public static String getRedirectPage() {
        return redirectPage;
    }

    static {
        InputStream in = PasswordHandlerConfig.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        try {
            props.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

