/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.protocol.impl.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.UUID;
import org.jboss.aerogear.simplepush.protocol.Ack;
import org.jboss.aerogear.simplepush.protocol.AckMessage;
import org.jboss.aerogear.simplepush.protocol.HelloMessage;
import org.jboss.aerogear.simplepush.protocol.HelloResponse;
import org.jboss.aerogear.simplepush.protocol.MessageType;
import org.jboss.aerogear.simplepush.protocol.NotificationMessage;
import org.jboss.aerogear.simplepush.protocol.PingMessage;
import org.jboss.aerogear.simplepush.protocol.RegisterMessage;
import org.jboss.aerogear.simplepush.protocol.RegisterResponse;
import org.jboss.aerogear.simplepush.protocol.UnregisterMessage;
import org.jboss.aerogear.simplepush.protocol.UnregisterResponse;
import org.jboss.aerogear.simplepush.protocol.impl.AckImpl;
import org.jboss.aerogear.simplepush.protocol.impl.AckMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.HelloMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.HelloResponseImpl;
import org.jboss.aerogear.simplepush.protocol.impl.NotificationMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.PingMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.RegisterMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.RegisterResponseImpl;
import org.jboss.aerogear.simplepush.protocol.impl.StatusImpl;
import org.jboss.aerogear.simplepush.protocol.impl.UnregisterMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.UnregisterResponseImpl;

public final class JsonUtil {
    private static ObjectMapper om = JsonUtil.createObjectMapper();

    private static ObjectMapper createObjectMapper() {
        om = new ObjectMapper();
        SimpleModule module = new SimpleModule("MyModule", new Version(0, 10, 0, null, "org.jboss.aerogear", "aerogear-simplepush-server"));
        module.addDeserializer(MessageType.class, (JsonDeserializer)new MessageTypeDeserializer());
        module.addDeserializer(RegisterMessageImpl.class, (JsonDeserializer)new RegisterDeserializer());
        module.addSerializer(RegisterMessageImpl.class, (JsonSerializer)new RegisterSerializer());
        module.addDeserializer(RegisterResponseImpl.class, (JsonDeserializer)new RegisterResponseDeserializer());
        module.addSerializer(RegisterResponseImpl.class, (JsonSerializer)new RegisterResponseSerializer());
        module.addDeserializer(HelloMessageImpl.class, (JsonDeserializer)new HelloDeserializer());
        module.addSerializer(HelloMessageImpl.class, (JsonSerializer)new HelloSerializer());
        module.addDeserializer(HelloResponseImpl.class, (JsonDeserializer)new HelloResponseDeserializer());
        module.addSerializer(HelloResponseImpl.class, (JsonSerializer)new HelloResponseSerializer());
        module.addDeserializer(AckMessageImpl.class, (JsonDeserializer)new AckDeserializer());
        module.addSerializer(AckMessageImpl.class, (JsonSerializer)new AckSerializer());
        module.addDeserializer(PingMessageImpl.class, (JsonDeserializer)new PingDeserializer());
        module.addSerializer(PingMessageImpl.class, (JsonSerializer)new PingSerializer());
        module.addDeserializer(NotificationMessageImpl.class, (JsonDeserializer)new NotificationDeserializer());
        module.addSerializer(NotificationMessageImpl.class, (JsonSerializer)new NotificationSerializer());
        module.addDeserializer(UnregisterMessageImpl.class, (JsonDeserializer)new UnregisterDeserializer());
        module.addSerializer(UnregisterMessageImpl.class, (JsonSerializer)new UnregisterMessageSerializer());
        module.addDeserializer(UnregisterResponseImpl.class, (JsonDeserializer)new UnregisterResponseDeserializer());
        module.addSerializer(UnregisterResponseImpl.class, (JsonSerializer)new UnregisterResponseSerializer());
        om.registerModule((Module)module);
        return om;
    }

    private JsonUtil() {
    }

    public static <T> T fromJson(String json, Class<T> type) {
        try {
            return (T)om.readValue(json, type);
        }
        catch (Exception e) {
            throw new RuntimeException("error trying to parse json [" + json + "]", e);
        }
    }

    public static String toJson(Object obj) {
        StringWriter stringWriter = new StringWriter();
        try {
            om.writeValue((Writer)stringWriter, obj);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("error trying to parse json [" + obj + "]", e);
        }
    }

    public static MessageType parseFrame(String json) {
        return JsonUtil.fromJson(json, MessageType.class);
    }

    private static class PingSerializer
    extends JsonSerializer<PingMessage> {
        private PingSerializer() {
        }

        public void serialize(PingMessage ping, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeEndObject();
        }
    }

    private static class PingDeserializer
    extends JsonDeserializer<PingMessageImpl> {
        private PingDeserializer() {
        }

        public PingMessageImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            if (node.isObject() && node.size() == 0) {
                return new PingMessageImpl(node.toString());
            }
            throw new RuntimeException("Invalid Ping message format : [" + node.toString() + "]");
        }
    }

    private static class UnregisterResponseSerializer
    extends JsonSerializer<UnregisterResponse> {
        private UnregisterResponseSerializer() {
        }

        public void serialize(UnregisterResponse unregisterResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("messageType");
            jgen.writeString(unregisterResponse.getMessageType().toString().toLowerCase());
            jgen.writeFieldName("channelID");
            jgen.writeString(unregisterResponse.getChannelId());
            jgen.writeFieldName("status");
            jgen.writeNumber(unregisterResponse.getStatus().getCode());
            jgen.writeEndObject();
        }
    }

    private static class UnregisterResponseDeserializer
    extends JsonDeserializer<UnregisterResponseImpl> {
        private UnregisterResponseDeserializer() {
        }

        public UnregisterResponseImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            JsonNode channelIdNode = node.get("channelID");
            return new UnregisterResponseImpl(channelIdNode.asText(), new StatusImpl(node.get("status").asInt(), "N/A"));
        }
    }

    private static class MessageTypeDeserializer
    extends JsonDeserializer<MessageType> {
        private MessageTypeDeserializer() {
        }

        public MessageType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            final JsonNode messageTypeNode = node.get("messageType");
            return new MessageType(){

                @Override
                public MessageType.Type getMessageType() {
                    if (messageTypeNode == null) {
                        return MessageType.Type.PING;
                    }
                    return MessageType.Type.valueOf(messageTypeNode.asText().toUpperCase());
                }
            };
        }
    }

    private static class UnregisterMessageSerializer
    extends JsonSerializer<UnregisterMessage> {
        private UnregisterMessageSerializer() {
        }

        public void serialize(UnregisterMessage unregister, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("messageType");
            jgen.writeString(unregister.getMessageType().toString().toLowerCase());
            jgen.writeFieldName("channelID");
            jgen.writeString(unregister.getChannelId());
            jgen.writeEndObject();
        }
    }

    private static class UnregisterDeserializer
    extends JsonDeserializer<UnregisterMessageImpl> {
        private UnregisterDeserializer() {
        }

        public UnregisterMessageImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            JsonNode channelIdNode = node.get("channelID");
            return new UnregisterMessageImpl(channelIdNode.asText());
        }
    }

    private static class NotificationSerializer
    extends JsonSerializer<NotificationMessage> {
        private NotificationSerializer() {
        }

        public void serialize(NotificationMessage notification, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("messageType");
            jgen.writeString(notification.getMessageType().toString().toLowerCase());
            jgen.writeArrayFieldStart("updates");
            for (Ack ack : notification.getAcks()) {
                jgen.writeStartObject();
                jgen.writeFieldName("channelID");
                jgen.writeString(ack.getChannelId());
                jgen.writeFieldName("version");
                jgen.writeNumber(ack.getVersion());
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
        }
    }

    private static class NotificationDeserializer
    extends JsonDeserializer<NotificationMessageImpl> {
        private NotificationDeserializer() {
        }

        public NotificationMessageImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            JsonNode updatesNode = node.get("updates");
            HashSet<Ack> acks = new HashSet<Ack>();
            if (updatesNode.isArray()) {
                for (JsonNode channelNode : updatesNode) {
                    JsonNode versionNode = channelNode.get("version");
                    JsonNode channelIdNode = channelNode.get("channelID");
                    acks.add(new AckImpl(channelIdNode.asText(), versionNode.asLong()));
                }
            }
            return new NotificationMessageImpl(acks);
        }
    }

    private static class AckSerializer
    extends JsonSerializer<AckMessage> {
        private AckSerializer() {
        }

        public void serialize(AckMessage ackMessage, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("messageType");
            jgen.writeString(ackMessage.getMessageType().toString().toLowerCase());
            jgen.writeArrayFieldStart("updates");
            for (Ack ack : ackMessage.getAcks()) {
                jgen.writeStartObject();
                jgen.writeFieldName("channelID");
                jgen.writeString(ack.getChannelId());
                jgen.writeFieldName("version");
                jgen.writeNumber(ack.getVersion());
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
        }
    }

    private static class AckDeserializer
    extends JsonDeserializer<AckMessageImpl> {
        private AckDeserializer() {
        }

        public AckMessageImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            JsonNode acksNode = node.get("updates");
            HashSet<Ack> acks = new HashSet<Ack>();
            if (acksNode.isArray()) {
                for (JsonNode ackNode : acksNode) {
                    acks.add(new AckImpl(ackNode.get("channelID").asText(), ackNode.get("version").asLong()));
                }
            }
            return new AckMessageImpl(acks);
        }
    }

    private static class HelloResponseSerializer
    extends JsonSerializer<HelloResponse> {
        private HelloResponseSerializer() {
        }

        public void serialize(HelloResponse helloResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("messageType");
            jgen.writeString(helloResponse.getMessageType().toString().toLowerCase());
            jgen.writeFieldName("uaid");
            jgen.writeString(helloResponse.getUAID());
            jgen.writeEndObject();
        }
    }

    private static class HelloResponseDeserializer
    extends JsonDeserializer<HelloResponseImpl> {
        private HelloResponseDeserializer() {
        }

        public HelloResponseImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            JsonNode uaid = node.get("uaid");
            return new HelloResponseImpl(UUID.fromString(uaid.asText()).toString());
        }
    }

    private static class HelloSerializer
    extends JsonSerializer<HelloMessage> {
        private HelloSerializer() {
        }

        public void serialize(HelloMessage hello, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("messageType");
            jgen.writeString(hello.getMessageType().toString().toLowerCase());
            jgen.writeFieldName("uaid");
            jgen.writeString(hello.getUAID());
            jgen.writeArrayFieldStart("channelIDs");
            for (String channelId : hello.getChannelIds()) {
                jgen.writeString(channelId);
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
        }
    }

    private static class HelloDeserializer
    extends JsonDeserializer<HelloMessageImpl> {
        private HelloDeserializer() {
        }

        public HelloMessageImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode uaid;
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            JsonNode channelIdsNode = node.get("channelIDs");
            HashSet<String> channelIds = new HashSet<String>();
            if (channelIdsNode != null && channelIdsNode.isArray()) {
                for (JsonNode channelIdNode : channelIdsNode) {
                    channelIds.add(channelIdNode.asText());
                }
            }
            if ((uaid = node.get("uaid")) != null) {
                return new HelloMessageImpl(node.get("uaid").asText(), channelIds);
            }
            return new HelloMessageImpl();
        }
    }

    private static class RegisterResponseSerializer
    extends JsonSerializer<RegisterResponse> {
        private RegisterResponseSerializer() {
        }

        public void serialize(RegisterResponse registerResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("messageType");
            jgen.writeString(registerResponse.getMessageType().toString().toLowerCase());
            jgen.writeFieldName("channelID");
            jgen.writeString(registerResponse.getChannelId());
            jgen.writeFieldName("status");
            jgen.writeNumber(registerResponse.getStatus().getCode());
            jgen.writeFieldName("pushEndpoint");
            jgen.writeString(registerResponse.getPushEndpoint());
            jgen.writeEndObject();
        }
    }

    private static class RegisterResponseDeserializer
    extends JsonDeserializer<RegisterResponseImpl> {
        private RegisterResponseDeserializer() {
        }

        public RegisterResponseImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            return new RegisterResponseImpl(node.get("channelID").asText(), new StatusImpl(node.get("status").asInt(), "N/A"), node.get("pushEndpoint").asText());
        }
    }

    private static class RegisterSerializer
    extends JsonSerializer<RegisterMessage> {
        private RegisterSerializer() {
        }

        public void serialize(RegisterMessage register, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeFieldName("messageType");
            jgen.writeString(register.getMessageType().toString().toLowerCase());
            jgen.writeFieldName("channelID");
            jgen.writeString(register.getChannelId());
            jgen.writeEndObject();
        }
    }

    private static class RegisterDeserializer
    extends JsonDeserializer<RegisterMessageImpl> {
        private RegisterDeserializer() {
        }

        public RegisterMessageImpl deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            return new RegisterMessageImpl(node.get("channelID").asText());
        }
    }
}

