/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server;

import org.jboss.aerogear.simplepush.server.Channel;
import org.jboss.aerogear.simplepush.util.ArgumentUtil;

public class DefaultChannel
implements Channel {
    private final String uaid;
    private final String channelId;
    private final String endpointToken;
    private final long version;

    public DefaultChannel(String uaid, String channelId, String endpointToken) {
        this(uaid, channelId, 0L, endpointToken);
    }

    public DefaultChannel(String uaid, String channelId, long version, String endpointToken) {
        ArgumentUtil.checkNotNull((Object)uaid, (String)"uaid");
        ArgumentUtil.checkNotNull((Object)channelId, (String)"channelId");
        ArgumentUtil.checkNotNegative((long)version, (String)"version");
        ArgumentUtil.checkNotNull((Object)endpointToken, (String)"endpointToken");
        this.uaid = uaid;
        this.channelId = channelId;
        this.version = version;
        this.endpointToken = endpointToken;
    }

    @Override
    public String getUAID() {
        return this.uaid;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public String getEndpointToken() {
        return this.endpointToken;
    }

    public String toString() {
        return "DefaultChannel[uaid=" + this.uaid + ", channelId=" + this.channelId + ", version=" + this.version + ", pushEndpoint=" + this.endpointToken + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.channelId == null ? 0 : this.channelId.hashCode());
        result = 31 * result + (this.endpointToken == null ? 0 : this.endpointToken.hashCode());
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        DefaultChannel o = (DefaultChannel)obj;
        return (this.uaid == null ? o.uaid == null : this.uaid.equals(o.uaid)) && (this.channelId == null ? o.channelId == null : this.channelId.equals(o.channelId)) && (this.endpointToken == null ? o.endpointToken == null : this.endpointToken.equals(o.endpointToken)) && this.version == o.version;
    }
}

