/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.subsystem;

import java.util.List;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.simplepush.server.DefaultSimplePushConfig;
import org.jboss.aerogear.simplepush.server.datastore.DataStore;
import org.jboss.aerogear.simplepush.subsystem.DataStoreDefinition;
import org.jboss.aerogear.simplepush.subsystem.DataStoreService;
import org.jboss.aerogear.simplepush.subsystem.ServerDefinition;
import org.jboss.aerogear.simplepush.subsystem.SimplePushService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

class ServerAdd
extends AbstractAddStepHandler {
    public static final ServerAdd INSTANCE = new ServerAdd();
    private final Logger logger = Logger.getLogger(ServerAdd.class);

    private ServerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ServerDefinition.SERVER_NAME_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKET_BINDING_ATTR.validateAndSet(operation, model);
        ServerDefinition.PASSWORD_ATTR.validateAndSet(operation, model);
        ServerDefinition.REAPER_TIMEOUT_ATTR.validateAndSet(operation, model);
        ServerDefinition.ENDPOINT_TLS_ATTR.validateAndSet(operation, model);
        ServerDefinition.ENDPOINT_PREFIX_ATTR.validateAndSet(operation, model);
        ServerDefinition.ENDPOINT_ACK_INTERVAL_ATTR.validateAndSet(operation, model);
        ServerDefinition.ENDPOINT_SOCKET_BINDING_ATTR.validateAndSet(operation, model);
        ServerDefinition.NOTIFIER_MAX_THREADS.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_PREFIX_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_COOKIES_NEEDED_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_URL_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_SESSION_TIMEOUT_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_HEARTBEAT_INTERVAL_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_MAX_STREAMING_BYTES_SIZE_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_TLS_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_KEYSTORE_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_KEYSTORE_PASSWORD_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_ENABLE_WEBSOCKET_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_WEBSOCKET_HEARTBEAT_INTERVAL_ATTR.validateAndSet(operation, model);
        ServerDefinition.SOCKJS_WEBSOCKET_PROTOCOLS.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode datasourceNode;
        DefaultSimplePushConfig.Builder simplePushConfig = this.parseSimplePushOptions(context, model);
        SockJsConfig sockJsConfig = this.parseSockJsOptions(context, model);
        SimplePushService simplePushService = new SimplePushService(simplePushConfig, sockJsConfig);
        String serverName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName serviceName = SimplePushService.createServiceName(serverName);
        ServiceBuilder sb = context.getServiceTarget().addService(serviceName, (Service)simplePushService);
        String socketBinding = ServerDefinition.SOCKET_BINDING_ATTR.resolveModelAttribute(context, model).asString();
        sb.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding}), SocketBinding.class, simplePushService.getInjectedSocketBinding());
        ModelNode notificationSocketBinding = ServerDefinition.ENDPOINT_SOCKET_BINDING_ATTR.resolveModelAttribute(context, model);
        if (notificationSocketBinding.isDefined()) {
            sb.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{notificationSocketBinding.asString()}), SocketBinding.class, simplePushService.getInjectedNotificationSocketBinding());
        }
        if ((datasourceNode = DataStoreDefinition.DATASOURCE_ATTR.resolveModelAttribute(context, model)).isDefined()) {
            ContextNames.BindInfo bindinfo = ContextNames.bindInfoFor((String)datasourceNode.asString());
            this.logger.debug((Object)("Adding dependency to [" + bindinfo.getAbsoluteJndiName() + "]"));
            sb.addDependencies(new ServiceName[]{bindinfo.getBinderServiceName()});
        }
        sb.addDependency(DataStoreService.SERVICE_NAME.append(new String[]{serverName}), DataStore.class, simplePushService.getInjectedDataStore());
        sb.addListener((ServiceListener)verificationHandler);
        sb.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(sb.install());
    }

    private SockJsConfig parseSockJsOptions(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode sockJsPrefix = ServerDefinition.SOCKJS_PREFIX_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsCookiesNeeded = ServerDefinition.SOCKJS_COOKIES_NEEDED_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsUrl = ServerDefinition.SOCKJS_URL_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsSessionTimeout = ServerDefinition.SOCKJS_SESSION_TIMEOUT_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsHeartbeatInterval = ServerDefinition.SOCKJS_HEARTBEAT_INTERVAL_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsMaxStreamingBytesSize = ServerDefinition.SOCKJS_MAX_STREAMING_BYTES_SIZE_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsTls = ServerDefinition.SOCKJS_TLS_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsKeystore = ServerDefinition.SOCKJS_KEYSTORE_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsKeystorePassword = ServerDefinition.SOCKJS_KEYSTORE_PASSWORD_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsEnableWebSocket = ServerDefinition.SOCKJS_ENABLE_WEBSOCKET_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsWebSocketHeartbeatInterval = ServerDefinition.SOCKJS_WEBSOCKET_HEARTBEAT_INTERVAL_ATTR.resolveModelAttribute(context, model);
        ModelNode sockJsWebSocketProtocols = ServerDefinition.SOCKJS_WEBSOCKET_PROTOCOLS.resolveModelAttribute(context, model);
        SockJsConfig.Builder sockJsConfig = new SockJsConfig.Builder(sockJsPrefix.asString());
        if (sockJsCookiesNeeded.isDefined() && sockJsCookiesNeeded.asBoolean()) {
            sockJsConfig.cookiesNeeded();
        }
        if (sockJsUrl.isDefined()) {
            sockJsConfig.sockJsUrl(sockJsUrl.asString());
        }
        if (sockJsSessionTimeout.isDefined()) {
            sockJsConfig.sessionTimeout(sockJsSessionTimeout.asLong());
        }
        if (sockJsHeartbeatInterval.isDefined()) {
            sockJsConfig.heartbeatInterval(sockJsHeartbeatInterval.asLong());
        }
        if (sockJsMaxStreamingBytesSize.isDefined()) {
            sockJsConfig.maxStreamingBytesSize(sockJsMaxStreamingBytesSize.asInt());
        }
        if (sockJsTls.isDefined()) {
            sockJsConfig.tls(sockJsTls.asBoolean());
        }
        if (sockJsEnableWebSocket.isDefined() && !sockJsEnableWebSocket.asBoolean()) {
            sockJsConfig.disableWebSocket();
        }
        if (sockJsWebSocketHeartbeatInterval.isDefined()) {
            sockJsConfig.webSocketHeartbeatInterval(sockJsWebSocketHeartbeatInterval.asLong());
        }
        if (sockJsWebSocketProtocols.isDefined()) {
            sockJsConfig.webSocketProtocols(sockJsWebSocketProtocols.asString().split(","));
        }
        if (sockJsKeystore.isDefined()) {
            sockJsConfig.keyStore(sockJsKeystore.asString());
        }
        if (sockJsKeystorePassword.isDefined()) {
            sockJsConfig.keyStorePassword(sockJsKeystorePassword.asString());
        }
        return sockJsConfig.build();
    }

    private DefaultSimplePushConfig.Builder parseSimplePushOptions(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode reaperTimeout = ServerDefinition.REAPER_TIMEOUT_ATTR.resolveModelAttribute(context, model);
        ModelNode notificationPrefix = ServerDefinition.ENDPOINT_PREFIX_ATTR.resolveModelAttribute(context, model);
        ModelNode notificationtTls = ServerDefinition.ENDPOINT_TLS_ATTR.resolveModelAttribute(context, model);
        ModelNode notificationAckInterval = ServerDefinition.ENDPOINT_ACK_INTERVAL_ATTR.resolveModelAttribute(context, model);
        ModelNode notifierMaxThreads = ServerDefinition.NOTIFIER_MAX_THREADS.resolveModelAttribute(context, model);
        DefaultSimplePushConfig.Builder simplePushConfig = DefaultSimplePushConfig.create();
        simplePushConfig.password(ServerDefinition.PASSWORD_ATTR.resolveModelAttribute(context, model).asString());
        if (notificationtTls.isDefined()) {
            simplePushConfig.endpointTls(notificationtTls.asBoolean());
        }
        if (reaperTimeout.isDefined()) {
            simplePushConfig.userAgentReaperTimeout(Long.valueOf(reaperTimeout.asLong()));
        }
        if (notificationPrefix.isDefined()) {
            simplePushConfig.endpointPrefix(notificationPrefix.asString());
        }
        if (notificationAckInterval.isDefined()) {
            simplePushConfig.ackInterval(Long.valueOf(notificationAckInterval.asLong()));
        }
        if (notifierMaxThreads.isDefined()) {
            simplePushConfig.notifierMaxThreads(notifierMaxThreads.asInt());
        }
        return simplePushConfig;
    }
}

