/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import java.util.Collections;
import org.jboss.aerogear.webpush.DefaultWebPushServer;
import org.jboss.aerogear.webpush.WebPushServer;
import org.jboss.aerogear.webpush.WebPushServerConfig;
import org.jboss.aerogear.webpush.datastore.DataStore;
import org.jboss.aerogear.webpush.netty.Http2OrHttpHandler;
import org.jboss.aerogear.webpush.netty.WebPushHttp2Handler;

public class WebPushChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;
    private final DataStore dataStore;
    private final WebPushServerConfig config;
    private final byte[] privateKey;

    public WebPushChannelInitializer(SslContext sslCtx, DataStore dataStore, WebPushServerConfig config) {
        this.sslCtx = sslCtx;
        this.dataStore = dataStore;
        this.config = config;
        this.privateKey = DefaultWebPushServer.generateAndStorePrivateKey((DataStore)dataStore, (WebPushServerConfig)config);
    }

    public void initChannel(SocketChannel ch) {
        DefaultWebPushServer webPushServer = new DefaultWebPushServer(this.dataStore, this.config, this.privateKey);
        if (this.sslCtx != null) {
            this.configureSsl(ch, (WebPushServer)webPushServer);
        } else {
            this.configureClearText(ch, (WebPushServer)webPushServer);
        }
    }

    private void configureSsl(SocketChannel ch, WebPushServer webPushServer) {
        ch.pipeline().addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc()), new Http2OrHttpHandler(webPushServer)});
    }

    private void configureClearText(SocketChannel ch, WebPushServer webPushServer) {
        Http2ServerUpgradeCodec upgradeCodec = new Http2ServerUpgradeCodec((Http2ConnectionHandler)new WebPushHttp2Handler(webPushServer));
        HttpServerCodec sourceCodec = new HttpServerCodec();
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, Collections.singletonList(upgradeCodec), 65536);
        ch.pipeline().addLast(new ChannelHandler[]{sourceCodec});
        ch.pipeline().addLast(new ChannelHandler[]{upgradeHandler});
    }
}

