/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http2.Http2OrHttpChooser;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import org.jboss.aerogear.webpush.WebPushServerConfig;
import org.jboss.aerogear.webpush.datastore.DataStore;
import org.jboss.aerogear.webpush.datastore.InMemoryDataStore;
import org.jboss.aerogear.webpush.netty.WebPushChannelInitializer;
import org.jboss.aerogear.webpush.standalone.ConfigReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebPushNettyServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebPushNettyServer.class);
    private static final String DEFAULT_CONFIG = "/webpush-config.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        WebPushServerConfig config = WebPushNettyServer.readConfig(args);
        InMemoryDataStore inMemoryDataStore = new InMemoryDataStore();
        SslContext sslCtx = WebPushNettyServer.createSslContext(config);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.option(ChannelOption.SO_BACKLOG, (Object)1024)).group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new WebPushChannelInitializer(sslCtx, (DataStore)inMemoryDataStore, config));
            Channel ch = b.bind(config.host(), config.port()).sync().channel();
            LOGGER.info("WebPush server bound to {}:{}", (Object)config.host(), (Object)config.port());
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    private static WebPushServerConfig readConfig(String[] args) throws Exception {
        return ConfigReader.parse((String)(args.length == 1 ? args[0] : DEFAULT_CONFIG));
    }

    private static SslContext createSslContext(WebPushServerConfig config) throws Exception {
        if (config.useEndpointTls()) {
            return SslContext.newServerContext((SslProvider)SslProvider.JDK, (File)config.cert(), (File)config.privateKey(), null, (Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, (ApplicationProtocolConfig)new ApplicationProtocolConfig(WebPushNettyServer.protocol(config), ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[]{Http2OrHttpChooser.SelectedProtocol.HTTP_2.protocolName(), Http2OrHttpChooser.SelectedProtocol.HTTP_1_1.protocolName()}), (long)0L, (long)0L);
        }
        return null;
    }

    private static ApplicationProtocolConfig.Protocol protocol(WebPushServerConfig config) {
        switch (config.protocol()) {
            case ALPN: {
                return ApplicationProtocolConfig.Protocol.ALPN;
            }
            case NPN: {
                return ApplicationProtocolConfig.Protocol.NPN;
            }
        }
        throw new IllegalStateException("Protocol not supported [" + config.protocol() + "]");
    }
}

