package com.offbytwo.jenkins.model.credentials;


import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.offbytwo.jenkins.model.BaseModel;

import java.util.Map;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "typeName", defaultImpl = UsernamePasswordCredential.class)
@JsonSubTypes({@JsonSubTypes.Type(value = UsernamePasswordCredential.class, name = UsernamePasswordCredential.TYPENAME),
        @JsonSubTypes.Type(value = SSHKeyCredential.class, name = SSHKeyCredential.TYPENAME),
        @JsonSubTypes.Type(value = SecretTextCredential.class, name = SecretTextCredential.TYPENAME),
        @JsonSubTypes.Type(value = CertificateCredential.class, name = CertificateCredential.TYPENAME),
        @JsonSubTypes.Type(value = AppleDeveloperProfileCredential.class, name = AppleDeveloperProfileCredential.TYPENAME)})
/**
 * Base class for credentials. Should not be instantiated directly.
 */
public abstract class Credential extends BaseModel {

    protected static final String SCOPE_GLOBAL = "GLOBAL";

    private String id = "";
    private String scope = SCOPE_GLOBAL;
    private String description = "";
    private String fullName = "";
    private String displayName = "";

    private String typeName = "";

    public String getScope() {
        return scope;
    }

    /**
     * Set the scope of the credential. It is "GLOBAL" by default. Should not be changed.
     * @param scope
     */
    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    /**
     * Set the id of the credential. When creating a new credential, if this is not provided, a random id will be generated by Jenkins.
     * Required for update and delete operations
     * @param id the id of the credential.
     */
    public void setId(String id) {
        this.id = id;
    }

    public String getFullName() {
        return fullName;
    }

    /**
     * Should not be used. The value is set by Jenkins.
     * @param fullName
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getTypeName() {
        return typeName;
    }

    /**
     * Should not be used. The value is set by Jenkins.
     * @param typeName
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Should not be used. The value is set by Jenkins
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public abstract Map<String, Object> dataForCreate();

    public abstract Map<String, Object> dataForUpdate();

    /**
     * Indicate if the request should be sent as multipart/form data
     * @return
     */
    public boolean useMultipartForm() {
        return false;
    }
}
