/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model.credentials;

import com.offbytwo.jenkins.model.credentials.Credential;
import java.util.HashMap;
import java.util.Map;

public class SSHKeyCredential
extends Credential {
    public static final String TYPENAME = "SSH Username with private key";
    private static final String BASECLASS = "com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey";
    private static final String DIRECT_ENTRY_CLASS = "com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey$DirectEntryPrivateKeySource";
    private static final String FILE_ON_MASTER_CLASS = "com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey$FileOnMasterPrivateKeySource";
    private static final String USERS_PRIVATE_KEY_CLASS = "com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey$UsersPrivateKeySource";
    private String username;
    private String passphrase;
    private String privateKeyValue;
    private PRIVATE_KEY_TYPES privateKeyType;

    public SSHKeyCredential() {
        this.setTypeName(TYPENAME);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getPrivateKeyValue() {
        return this.privateKeyValue;
    }

    public void setPrivateKeyValue(String privateKeyValue) {
        this.privateKeyValue = privateKeyValue;
    }

    public PRIVATE_KEY_TYPES getPrivateKeyType() {
        return this.privateKeyType;
    }

    public void setPrivateKeyType(PRIVATE_KEY_TYPES privateKeyType) {
        this.privateKeyType = privateKeyType;
    }

    @Override
    public Map<String, Object> dataForCreate() {
        HashMap<String, String> privateKeySourceMap = new HashMap<String, String>();
        privateKeySourceMap.put("value", String.valueOf(this.getPrivateKeyType().getTypeValue()));
        privateKeySourceMap.put("privateKey", this.getPrivateKeyValue());
        privateKeySourceMap.put("stapler-class", this.getPrivateKeyType().getTypeClass());
        HashMap<String, Object> innerMap = new HashMap<String, Object>();
        innerMap.put("scope", "GLOBAL");
        innerMap.put("id", this.getId());
        innerMap.put("username", this.getUsername());
        innerMap.put("description", this.getDescription());
        innerMap.put("passphrase", this.getPassphrase());
        innerMap.put("stapler-class", BASECLASS);
        innerMap.put("$class", BASECLASS);
        innerMap.put("privateKeySource", privateKeySourceMap);
        HashMap<String, Object> jsonData = new HashMap<String, Object>();
        jsonData.put("", "1");
        jsonData.put("credentials", innerMap);
        return jsonData;
    }

    @Override
    public Map<String, Object> dataForUpdate() {
        HashMap<String, String> privateKeySourceMap = new HashMap<String, String>();
        privateKeySourceMap.put("value", String.valueOf(this.getPrivateKeyType().getTypeValue()));
        privateKeySourceMap.put("privateKey", this.getPrivateKeyValue());
        privateKeySourceMap.put("stapler-class", this.getPrivateKeyType().getTypeClass());
        HashMap<String, Object> jsonData = new HashMap<String, Object>();
        jsonData.put("scope", "GLOBAL");
        jsonData.put("id", this.getId());
        jsonData.put("username", this.getUsername());
        jsonData.put("description", this.getDescription());
        jsonData.put("passphrase", this.getPassphrase());
        jsonData.put("stapler-class", BASECLASS);
        jsonData.put("$class", BASECLASS);
        jsonData.put("privateKeySource", privateKeySourceMap);
        return jsonData;
    }

    public static enum PRIVATE_KEY_TYPES {
        DIRECT_ENTRY("com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey$DirectEntryPrivateKeySource", 0),
        FILE_ON_MASTER("com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey$FileOnMasterPrivateKeySource", 1),
        USERS_PRIVATE_KEY("com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey$UsersPrivateKeySource", 2);

        private String privateKeyTypeClass;
        private int typeValue;

        private PRIVATE_KEY_TYPES(String typeClass, int typeValue) {
            this.privateKeyTypeClass = typeClass;
            this.typeValue = typeValue;
        }

        public String getTypeClass() {
            return this.privateKeyTypeClass;
        }

        public int getTypeValue() {
            return this.typeValue;
        }
    }
}

