/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model.credentials;

import com.offbytwo.jenkins.model.credentials.Credential;
import java.util.HashMap;
import java.util.Map;

public class UsernamePasswordCredential
extends Credential {
    public static final String TYPENAME = "Username with password";
    private static final String CLASSNAME = "com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl";
    private String username;
    private String password;

    public UsernamePasswordCredential() {
        this.setTypeName(TYPENAME);
    }

    public String getUsername() {
        if (this.username != null) {
            return this.username;
        }
        if (this.getDisplayName() != null) {
            return this.getDisplayName().split("/")[0];
        }
        return null;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Map<String, Object> dataForCreate() {
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("scope", this.getScope());
        innerMap.put("id", this.getId());
        innerMap.put("username", this.getUsername());
        innerMap.put("password", this.getPassword());
        innerMap.put("description", this.getDescription());
        innerMap.put("$class", CLASSNAME);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("", "0");
        data.put("credentials", innerMap);
        return data;
    }

    @Override
    public Map<String, Object> dataForUpdate() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("scope", this.getScope());
        data.put("id", this.getId());
        data.put("username", this.getUsername());
        data.put("password", this.getPassword());
        data.put("description", this.getDescription());
        data.put("stapler-class", CLASSNAME);
        return data;
    }
}

