/**
 * JBoss, Home of Professional Open Source
 * Copyright Red Hat, Inc., and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.aerogear.sync;

import java.util.Queue;

/**
 * Represents a stack of changes made on the server of client side.
 * <p>
 * A PatchMessage is what is passed between the client and the server. It contains a Queue of
 * {@link Edit}s that represent updates to be performed on the opposing sides document.
 *
 * @param <T> The type of the {@link Edit} that this PatchMessage holds
 */
public interface PatchMessage<T extends Edit<? extends Diff>> extends Payload<PatchMessage<T>> {

    /**
     * Identifies the client that this edit instance belongs to.
     *
     * @return {@code String} the client identifier.
     */
    String clientId();

    /**
     * Identifies the document that this edit is related to
     *
     * @return {@code String} the document documentId.
     */
    String documentId();

    /**
     * The individual {@link Edit}s.
     *
     * @return {@code Queue<Edit>} the individual edits.
     */
    Queue<T> edits();

}
