/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.client.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.Diff;
import org.jboss.aerogear.sync.Edit;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.client.ClientSyncEngine;
import org.jboss.aerogear.sync.client.PatchListener;
import org.jboss.aerogear.sync.client.SyncClient;
import org.jboss.aerogear.sync.client.netty.SyncClientHandler;
import org.jboss.aerogear.sync.client.netty.WebSocketClientHandler;
import org.jboss.aerogear.sync.util.Arguments;

public final class NettySyncClient<T, S extends Edit<? extends Diff>>
implements SyncClient<T, S> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NettySyncClient.class);
    private final String host;
    private final int port;
    private final String path;
    private final URI uri;
    private final ClientSyncEngine<T, S> syncEngine;
    private final String subprotocols;
    private EventLoopGroup group;
    private Channel channel;

    private NettySyncClient(Builder<T, S> builder) {
        this.host = (String)Arguments.checkNotNull((Object)((Builder)builder).host, (String)"host must not be null");
        this.path = (String)Arguments.checkNotNull((Object)((Builder)builder).path, (String)"path must not be null");
        this.syncEngine = (ClientSyncEngine)Arguments.checkNotNull((Object)((Builder)builder).engine, (String)"engine must not be null");
        this.port = ((Builder)builder).port;
        this.uri = NettySyncClient.parseUri(((Builder)builder).wss, this.host, this.port, this.path);
        this.subprotocols = ((Builder)builder).subprotocols;
        if (((Builder)builder).listener != null) {
            this.syncEngine.addPatchListener(((Builder)builder).listener);
        }
    }

    public NettySyncClient<T, S> connect() throws InterruptedException {
        final SyncClientHandler<T, S> syncClientHandler = new SyncClientHandler<T, S>(this.syncEngine);
        final WebSocketClientHandler handler = this.newWebSocketClientHandler();
        Bootstrap b = new Bootstrap();
        this.group = new NioEventLoopGroup();
        ((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class);
        b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), handler, syncClientHandler});
            }
        });
        this.channel = b.connect(this.host, this.port).sync().channel();
        handler.handshakeFuture().sync();
        logger.info("SyncClient connected to {}:{}", (Object)this.host, (Object)this.port);
        return this;
    }

    public void addDocument(ClientDocument<T> document) {
        this.syncEngine.addDocument(document);
        if (this.channel.isOpen()) {
            String json = this.syncEngine.documentToJson(document);
            this.channel.writeAndFlush((Object)new TextWebSocketFrame(json));
        }
    }

    public void diffAndSend(ClientDocument<T> document) {
        PatchMessage patchMessage = this.syncEngine.diff(document);
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush((Object)new TextWebSocketFrame(patchMessage.asJson()));
        }
    }

    public void disconnect() {
        this.channel.close();
        this.group.shutdownGracefully();
        logger.info("SyncClient disconnected");
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }

    public void addPatchListener(PatchListener<T> listener) {
        this.syncEngine.addPatchListener(listener);
    }

    public void deletePatchListener(PatchListener<T> listener) {
        this.syncEngine.removePatchListener(listener);
    }

    public void deletePatchListeners() {
        this.syncEngine.removePatchListeners();
    }

    public int countPatchListeners() {
        return this.syncEngine.countPatchListeners();
    }

    public String clientId() {
        return "NettySyncClient";
    }

    private WebSocketClientHandler newWebSocketClientHandler() {
        return new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, (String)this.subprotocols, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()));
    }

    private static URI parseUri(boolean wss, String host, int port, String path) {
        try {
            return new URI(wss ? "wss" : "ws://" + host + ':' + port + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static <T, S extends Edit<? extends Diff>> Builder<T, S> forHost(String host) {
        return new Builder(host);
    }

    public static class Builder<T, S extends Edit<? extends Diff>> {
        private final String host;
        private int port;
        private String path;
        private boolean wss;
        private String subprotocols;
        private ClientSyncEngine<T, S> engine;
        private PatchListener<T> listener;

        public Builder(String host) {
            this.host = host;
        }

        public Builder<T, S> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T, S> path(String path) {
            this.path = path;
            return this;
        }

        public Builder<T, S> wss(boolean wss) {
            this.wss = wss;
            return this;
        }

        public Builder<T, S> subprotocols(String subprotocols) {
            this.subprotocols = subprotocols;
            return this;
        }

        public Builder<T, S> syncEngine(ClientSyncEngine<T, S> engine) {
            this.engine = engine;
            return this;
        }

        public Builder<T, S> patchListener(PatchListener<T> listener) {
            this.listener = listener;
            return this;
        }

        public NettySyncClient<T, S> build() {
            return new NettySyncClient(this);
        }
    }
}

