/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.client.netty;

import com.fasterxml.jackson.databind.JsonNode;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.aerogear.sync.Diff;
import org.jboss.aerogear.sync.Edit;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.client.ClientSyncEngine;
import org.jboss.aerogear.sync.diffmatchpatch.JsonMapper;
import org.jboss.aerogear.sync.server.MessageType;

public class SyncClientHandler<T, S extends Edit<? extends Diff>>
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SyncClientHandler.class);
    private final ClientSyncEngine<T, S> syncEngine;

    public SyncClientHandler(ClientSyncEngine<T, S> syncEngine) {
        this.syncEngine = syncEngine;
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof CloseWebSocketFrame) {
            logger.debug("Received closeFrame");
            ctx.close();
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            logger.info("TextWebSocketFrame: " + ((TextWebSocketFrame)frame).text());
            JsonNode json = JsonMapper.asJsonNode((String)((TextWebSocketFrame)frame).text());
            logger.info("json: " + json);
            switch (MessageType.from((String)json.get("msgType").asText())) {
                case PATCH: {
                    PatchMessage serverPatchMessage = this.syncEngine.patchMessageFromJson(json.toString());
                    logger.info("Edits: " + serverPatchMessage);
                    this.patch(serverPatchMessage);
                    break;
                }
                case UNKNOWN: {
                    SyncClientHandler.unknownMessageType(ctx, json);
                }
            }
        } else {
            ctx.fireChannelRead((Object)frame);
        }
    }

    private void patch(PatchMessage<S> clientEdit) {
        this.syncEngine.patch(clientEdit);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("Caught exception", cause);
    }

    private static void unknownMessageType(ChannelHandlerContext ctx, JsonNode json) {
        ctx.channel().writeAndFlush((Object)SyncClientHandler.textFrame("{\"result\": \"Unknown msgType '" + json.get("msgType").asText() + "'\"}"));
    }

    private static TextWebSocketFrame textFrame(String text) {
        return new TextWebSocketFrame(text);
    }
}

