/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.arquillian.container.check.impl;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import java.net.URI;
import java.util.logging.Logger;
import org.jboss.aerogear.test.arquillian.container.check.StatusCheck;
import org.jboss.aerogear.test.arquillian.container.check.StatusCheckException;
import org.jboss.arquillian.core.spi.Validate;

public class HTTPCodeStatusCheck
implements StatusCheck {
    private static final Logger logger = Logger.getLogger(HTTPCodeStatusCheck.class.getName());
    private URI uri;

    public void target(URI uri) {
        Validate.notNull((Object)uri, (String)"target URI to check status of can not be a null object");
        this.uri = uri;
    }

    public boolean execute() {
        if (this.uri == null) {
            throw new StatusCheckException("URI of target to check was not set.");
        }
        Response response = RestAssured.get((URI)this.uri);
        int statusCode = response.getStatusCode();
        logger.fine(String.format("Status code: %s", statusCode));
        return statusCode == 200;
    }
}

