/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAPushMessageInformationDao
extends JPABaseDao
implements PushMessageInformationDao {
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";

    public PageResult<PushMessageInformation> findAllForPushApplication(String pushApplicationId, boolean ascending, Integer page, Integer pageSize) {
        String query = "select pmi from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending);
        String countQuery = "select count(*) from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId";
        return this.executePagedQuery(pushApplicationId, "pushApplicationId", page, pageSize, query, "select count(*) from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId");
    }

    public PageResult<PushMessageInformation> findAllForVariant(String variantID, boolean ascending, Integer page, Integer pageSize) {
        String query = "select pmi from PushMessageInformation pmi JOIN fetch pmi.variantInformations vi where vi.variantID = :variantID ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending);
        String countQuery = "select count(*) from PushMessageInformation pmi JOIN pmi.variantInformations vi where vi.variantID = :variantID";
        return this.executePagedQuery(variantID, "variantID", page, pageSize, query, "select count(*) from PushMessageInformation pmi JOIN pmi.variantInformations vi where vi.variantID = :variantID");
    }

    private PageResult<PushMessageInformation> executePagedQuery(String param, String paramName, Integer page, Integer pageSize, String query, String countQuery) {
        List pushMessageInformationList = this.createQuery(query).setParameter(paramName, (Object)param).setFirstResult(page * pageSize).setMaxResults(pageSize.intValue()).getResultList();
        Long count = (Long)this.createQuery(countQuery).setParameter(paramName, (Object)param).getSingleResult();
        return new PageResult(pushMessageInformationList, count.longValue());
    }

    public long getNumberOfPushMessagesForApplications(String loginName) {
        return (Long)this.createQuery("select count(pmi) from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p where p.developer = :developer)").setParameter("developer", (Object)loginName).getSingleResult();
    }

    public PushMessageInformation find(String id) {
        return (PushMessageInformation)this.entityManager.find(PushMessageInformation.class, (Object)id);
    }

    public void create(PushMessageInformation pushMessageInformation) {
        this.persist(pushMessageInformation);
    }

    public void update(PushMessageInformation pushMessageInformation) {
        this.merge(pushMessageInformation);
    }

    public void delete(PushMessageInformation pushMessageInformation) {
        PushMessageInformation entity = this.find(pushMessageInformation.getId());
        this.remove(entity);
    }

    public List<String> findVariantIDsWithWarnings(String loginName) {
        List variantIDsWithWarnings = this.createQuery("select distinct vmi.variantID from VariantMetricInformation vmi where vmi.variantID IN (select t.variantID from Variant t where t.developer = :developer) and vmi.deliveryStatus = false").setParameter("developer", (Object)loginName).getResultList();
        return variantIDsWithWarnings;
    }

    public Map<String, Long> findTopThreeBusyVariantIDs(String loginName) {
        List topThree = this.createQuery("select distinct vmi.variantID, vmi.receivers from VariantMetricInformation vmi where vmi.variantID IN (select t.variantID from Variant t where t.developer = :developer) ORDER BY vmi.receivers DESC").setParameter("developer", (Object)loginName).setMaxResults(3).getResultList();
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Object[] objects : topThree) {
            result.put((String)objects[0], (Long)objects[1]);
        }
        return result;
    }

    private String ascendingOrDescending(boolean asc) {
        if (asc) {
            return ASC;
        }
        return DESC;
    }
}

