/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAInstallationDao
extends JPABaseDao
implements InstallationDao {
    public void create(Installation installation) {
        this.persist(installation);
    }

    public void update(Installation installation) {
        this.merge(installation);
    }

    public void delete(Installation installation) {
        Installation entity = (Installation)this.entityManager.find(Installation.class, (Object)installation.getId());
        this.remove(entity);
    }

    public PageResult<Installation> findInstallationsByVariantForDeveloper(String variantID, String developer, Integer page, Integer pageSize) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Installation.class);
        Root v = query.from(Installation.class);
        Join join = v.join("variant");
        Predicate[] predicates = this.getPredicates(variantID, developer, builder, join);
        query.where(predicates);
        List result = this.entityManager.createQuery(query).setFirstResult(page * pageSize).setMaxResults(pageSize.intValue()).getResultList();
        CriteriaQuery countQuery = builder.createQuery(Long.class);
        Join join1 = countQuery.from(Installation.class).join("variant");
        countQuery.where(this.getPredicates(variantID, developer, builder, join1));
        Long count = (Long)this.entityManager.createQuery(countQuery.select((Selection)builder.count((Expression)join1))).getSingleResult();
        return new PageResult(result, count.longValue());
    }

    public PageResult<Installation> findInstallationsByVariant(String variantID, Integer page, Integer pageSize) {
        return this.findInstallationsByVariantForDeveloper(variantID, null, page, pageSize);
    }

    private Predicate[] getPredicates(String variantID, String developer, CriteriaBuilder builder, Join join) {
        Predicate[] predicates = developer != null ? new Predicate[]{builder.equal((Expression)join.get("variantID"), (Object)variantID), builder.and(new Predicate[]{builder.equal((Expression)join.get("developer"), (Object)developer)})} : new Predicate[]{builder.equal((Expression)join.get("variantID"), (Object)variantID)};
        return predicates;
    }

    public Installation findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        return this.getSingleResultForQuery(this.createQuery("select installation from Installation installation  join installation.variant abstractVariant where abstractVariant.variantID = :variantID and installation.deviceToken = :deviceToken").setParameter("variantID", (Object)variantID).setParameter("deviceToken", (Object)deviceToken));
    }

    public List<Installation> findInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        if (deviceTokens == null || deviceTokens.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.createQuery("select installation from Installation installation  join installation.variant abstractVariant  where abstractVariant.variantID = :variantID and installation.deviceToken IN :deviceTokens").setParameter("variantID", (Object)variantID).setParameter("deviceTokens", deviceTokens).getResultList();
    }

    public List<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        StringBuilder jpqlString = new StringBuilder("select distinct installation.deviceToken from Installation installation").append(" left join installation.categories c ").append(" join installation.variant abstractVariant where abstractVariant.variantID = :variantID AND installation.enabled = true");
        return this.executeDynamicQuery(jpqlString, variantID, categories, aliases, deviceTypes);
    }

    public long getNumberOfDevicesForVariantIDs(String loginName) {
        return (Long)this.createQuery("select count(installation) from Installation installation join installation.variant abstractVariant where abstractVariant.variantID IN (select t.variantID from Variant t where t.developer = :developer) ").setParameter("developer", (Object)loginName).getSingleResult();
    }

    public Installation find(String id) {
        return (Installation)this.entityManager.find(Installation.class, (Object)id);
    }

    public long getNumberOfDevicesForVariantIDs() {
        return (Long)this.createQuery("select count(installation) from Installation installation join installation.variant abstractVariant where abstractVariant.variantID IN (select t.variantID from Variant t) ").getSingleResult();
    }

    private List<String> executeDynamicQuery(StringBuilder jpqlBaseString, String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        LinkedHashMap<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
        if (this.isListEmpty(aliases)) {
            jpqlBaseString.append(" and installation.alias IN :aliases");
            parameters.put("aliases", aliases);
        }
        if (this.isListEmpty(deviceTypes)) {
            jpqlBaseString.append(" and installation.deviceType IN :deviceTypes");
            parameters.put("deviceTypes", deviceTypes);
        }
        if (this.isListEmpty(categories)) {
            jpqlBaseString.append(" and ( c.name in (:categories))");
            parameters.put("categories", categories);
        }
        Query jpql = this.createQuery(jpqlBaseString.toString());
        jpql.setParameter("variantID", (Object)variantID);
        Set paramKeys = parameters.keySet();
        for (String parameterName : paramKeys) {
            jpql.setParameter(parameterName, parameters.get(parameterName));
        }
        return jpql.getResultList();
    }

    private boolean isListEmpty(List list) {
        return list != null && !list.isEmpty();
    }

    private Installation getSingleResultForQuery(Query query) {
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (Installation)result.get(0);
        }
        return null;
    }
}

