/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.notifications;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.windows.mpns.DeliveryClass;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.internal.Pair;

abstract class AbstractNotificationBuilder<A extends AbstractNotificationBuilder<A, B>, B extends MpnsNotification> {
    protected final List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();

    protected AbstractNotificationBuilder() {
    }

    protected AbstractNotificationBuilder(String type) {
        this.notificationType(type);
    }

    public A messageId(String messageId) {
        this.headers.add(Pair.of("X-MessageId", messageId));
        return (A)this;
    }

    public A notificationClass(DeliveryClass delivery) {
        this.headers.add(Pair.of("X-NotificationClass", String.valueOf(this.deliveryValueOf(delivery))));
        return (A)this;
    }

    public A notificationType(String type) {
        this.headers.add(Pair.of("X-WindowsPhone-Target", type));
        return (A)this;
    }

    public A callbackUri(String callbackUri) {
        this.headers.add(Pair.of("X-CallbackURI", callbackUri));
        return (A)this;
    }

    protected A contentType(String contentType) {
        this.headers.add(Pair.of("Content-Type", contentType));
        return (A)this;
    }

    protected abstract int deliveryValueOf(DeliveryClass var1);

    public abstract B build();
}

