/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.notifications;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.windows.mpns.DeliveryClass;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.internal.Utilities;
import org.jboss.aerogear.windows.mpns.notifications.AbstractNotificationBuilder;

public class TileNotification
implements MpnsNotification {
    private final Builder builder;
    private final List<? extends Map.Entry<String, String>> headers;

    public TileNotification(Builder builder, List<? extends Map.Entry<String, String>> headers) {
        this.builder = builder;
        this.headers = headers;
    }

    @Override
    public byte[] getRequestBody() {
        return this.builder.toByteArray();
    }

    @Override
    public List<? extends Map.Entry<String, String>> getHttpHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public static class Builder
    extends AbstractNotificationBuilder<Builder, TileNotification> {
        private String backgroundImage;
        private String title;
        private String backBackgroundImage;
        private String backTitle;
        private String backContent;
        private int count;

        public Builder() {
            super("token");
            this.contentType("text/xml");
        }

        public Builder backgroundImage(String backgroundImage) {
            this.backgroundImage = backgroundImage;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder backBackgroundImage(String backBackgroundImage) {
            this.backBackgroundImage = backBackgroundImage;
            return this;
        }

        public Builder backTitle(String backTitle) {
            this.backTitle = backTitle;
            return this;
        }

        public Builder backContent(String backContent) {
            this.backContent = backContent;
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        @Override
        protected int deliveryValueOf(DeliveryClass delivery) {
            return Utilities.getTileDelivery(delivery);
        }

        @Override
        public TileNotification build() {
            return new TileNotification(this, this.headers);
        }

        public byte[] toByteArray() {
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            sb.append("<wp:Notification xmlns:wp=\"WPNotification\">");
            sb.append("<wp:Tile>");
            sb.append(Utilities.xmlElement("BackgroundImage", this.backgroundImage));
            sb.append(Utilities.xmlElement("Count", "" + this.count));
            sb.append(Utilities.xmlElement("Title", this.title));
            sb.append(Utilities.xmlElement("BackBackgroundImage", this.backBackgroundImage));
            sb.append(Utilities.xmlElement("BackTitle", this.backTitle));
            sb.append(Utilities.xmlElement("BackContent", this.backContent));
            sb.append("</wp:Tile>");
            sb.append("</wp:Notification>");
            return Utilities.toUTF8(sb.toString());
        }
    }
}

