/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.windows.mpns.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.methods.HttpPost;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.MpnsService;
import org.jboss.aerogear.windows.mpns.internal.AbstractMpnsService;
import org.jboss.aerogear.windows.mpns.internal.Pair;

public class MpnsQueuedService
extends AbstractMpnsService
implements MpnsService {
    private final AbstractMpnsService service;
    private final BlockingQueue<Pair<HttpPost, MpnsNotification>> queue;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Thread thread;
    private volatile boolean shouldContinue;

    public MpnsQueuedService(AbstractMpnsService service) {
        this.service = service;
        this.queue = new LinkedBlockingQueue<Pair<HttpPost, MpnsNotification>>();
    }

    @Override
    protected void push(HttpPost request, MpnsNotification message) {
        if (!this.started.get()) {
            throw new IllegalStateException("Service hans't been started or was closed");
        }
        this.queue.add(Pair.of(request, message));
    }

    @Override
    public void start() {
        if (this.started.getAndSet(true)) {
            return;
        }
        this.service.start();
        this.shouldContinue = true;
        this.thread = new Thread(){

            @Override
            public void run() {
                while (MpnsQueuedService.this.shouldContinue) {
                    try {
                        Pair post = (Pair)MpnsQueuedService.this.queue.take();
                        MpnsQueuedService.this.service.push((HttpPost)post.getKey(), (MpnsNotification)post.getValue());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.thread.start();
    }

    @Override
    public void stop() {
        this.started.set(false);
        this.shouldContinue = false;
        this.thread.interrupt();
        this.service.stop();
    }
}

