/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.mkdir;

import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.terminal.Shell;

@CommandDefinition(name="mkdir", description="create directory(ies), if they do not already exist.")
public class Mkdir
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=112, name="parents", hasValue=false, description="make parent directories as needed")
    private boolean parents;
    @Option(shortName=118, name="verbose", hasValue=false, description="print a message for each created directory")
    private boolean verbose;
    @Arguments
    private List<Resource> arguments;

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        if (this.help || this.arguments == null || this.arguments.isEmpty()) {
            commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("mkdir"));
            return CommandResult.SUCCESS;
        }
        for (Resource f : this.arguments) {
            Resource currentWorkingDirectory = commandInvocation.getAeshContext().getCurrentWorkingDirectory();
            Shell shell = commandInvocation.getShell();
            Resource pathResolved = (Resource)f.resolve(currentWorkingDirectory).get(0);
            if (this.parents || f.getName().contains(Config.getPathSeparator())) {
                this.makeDirs(this.arguments, pathResolved, shell);
                continue;
            }
            this.makeDir(pathResolved, shell);
        }
        return CommandResult.SUCCESS;
    }

    private void makeDir(Resource dir, Shell shell) {
        if (!dir.exists()) {
            dir.mkdirs();
            if (this.verbose) {
                shell.out().println("created directory '" + dir.getName() + "'");
            }
        } else {
            shell.out().println("cannot create directory '" + dir.getName() + "': Directory exists");
        }
    }

    private void makeDirs(List<Resource> resources, Resource dir, Shell shell) {
        if (!dir.exists()) {
            dir.mkdirs();
            if (this.verbose) {
                for (Resource r : resources) {
                    shell.out().println("created directory '" + r.getName() + "'");
                }
            }
        }
    }
}

