/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.mv;

import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.io.Resource;

@CommandDefinition(name="mv", description="move files or directories.")
public class Mv
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=118, name="verbose", hasValue=false, description="explain what is being done")
    private boolean verbose;
    @Option(shortName=110, name="no-clobber", hasValue=false, description="do not overwrite an existing file")
    private boolean noClobber;
    @Arguments
    private List<Resource> args;

    public CommandResult execute(CommandInvocation ci) throws IOException, InterruptedException {
        if (this.help || this.args == null || this.args.isEmpty()) {
            ci.getShell().out().println(ci.getHelpInfo("mv"));
            return CommandResult.SUCCESS;
        }
        if (this.args != null && this.args.size() > 2) {
            ci.getShell().out().println("try: mv foo bar");
            return CommandResult.SUCCESS;
        }
        Resource currentDir = ci.getAeshContext().getCurrentWorkingDirectory();
        Resource from = (Resource)this.args.get(0).resolve(currentDir).get(0);
        Resource to = (Resource)this.args.get(1).resolve(currentDir).get(0);
        this.move(from, to, ci);
        return CommandResult.SUCCESS;
    }

    private void move(Resource from, Resource to, CommandInvocation ci) throws IOException, InterruptedException {
        if (from.exists()) {
            if (this.noClobber) {
                if (!to.exists()) {
                    from.move(to);
                }
            } else {
                from.move(to);
            }
            if (this.verbose) {
                ci.getShell().out().println("'" + from.getName() + "' -> '" + to.getName() + "'");
            }
        }
    }
}

