/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.rm;

import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.terminal.Key;

@CommandDefinition(name="rm", description="remove files or directories.")
public class Rm
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=100, name="dir", hasValue=false, description="remove empty directories")
    private boolean dir;
    @Option(shortName=105, name="interactive", hasValue=false, description="prompt before every removal")
    private boolean interactive;
    @Option(shortName=118, name="verbose", hasValue=false, description="explain what is being done")
    private boolean verbose;
    @Arguments
    private List<Resource> args;

    public CommandResult execute(CommandInvocation ci) throws IOException, InterruptedException {
        if (this.help || this.args == null || this.args.isEmpty()) {
            ci.getShell().out().println(ci.getHelpInfo("rm"));
            return CommandResult.SUCCESS;
        }
        Resource currentDir = ci.getAeshContext().getCurrentWorkingDirectory();
        for (Resource r : this.args) {
            Resource res = (Resource)r.resolve(currentDir).get(0);
            if (this.dir) {
                this.rmDir(res, ci);
                continue;
            }
            this.rmFile(res, ci);
        }
        return CommandResult.SUCCESS;
    }

    private void rmFile(Resource r, CommandInvocation ci) throws InterruptedException {
        if (r.exists()) {
            if (r.isLeaf()) {
                if (this.interactive) {
                    ci.getShell().out().println("remove regular file '" + r.getName() + "' ? (y/n)");
                    if (ci.getInput().getInputKey() == Key.y) {
                        r.delete();
                    }
                } else {
                    r.delete();
                }
                if (this.verbose) {
                    ci.getShell().out().println("removed '" + r.getName() + "'");
                }
            } else if (r.isDirectory()) {
                ci.getShell().out().println("cannot remove '" + r.getName() + "': Is a directory");
            }
        }
    }

    private void rmDir(Resource r, CommandInvocation ci) throws InterruptedException {
        if (r.exists() && r.isDirectory()) {
            if (this.interactive) {
                ci.getShell().out().println("remove directory '" + r.getName() + "' ? (y/n)");
                if (ci.getInput().getInputKey() == Key.y) {
                    r.delete();
                }
            } else {
                r.delete();
            }
            if (this.verbose) {
                ci.getShell().out().println("removed directory: '" + r.getName() + "'");
            }
        }
    }
}

