/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.ui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.jboss.aophelper.ui.AopHelperMediator;

public class AopHelperMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private JMenuItem compile;
    private JMenuItem run;
    private JMenuItem about;

    public AopHelperMenuBar() {
        this.init();
    }

    private void init() {
        this.add(this.createFileMenu());
        this.add(this.createEditMenu());
        this.add(Box.createHorizontalGlue());
        this.add(this.createHelpMenu());
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        this.about = new JMenuItem("About", 65);
        this.about.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        helpMenu.add(this.about);
        this.about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.out.println("About..");
                AopHelperMenuBar.this.showDialog();
            }
        });
        return helpMenu;
    }

    private void showDialog() {
        JOptionPane.showMessageDialog(this, "JBoss AOP Helper is intendend to \n help users easily test and run their aop apps\n  without going through ant/maven.\n\n NOTE: Aophelper is still in beta stage.");
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        this.compile = new JMenuItem("AOP Compile mode", 67);
        this.compile.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        fileMenu.add(this.compile);
        this.run = new JMenuItem("AOP Run mode", 82);
        this.run.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        fileMenu.add(this.run);
        final JMenuItem exit = new JMenuItem("Exit", 81);
        exit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        fileMenu.add(exit);
        fileMenu.insertSeparator(2);
        ActionListener menuListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == exit) {
                    AopHelperMediator.instance().quit();
                }
                if (event.getSource() == AopHelperMenuBar.this.compile) {
                    AopHelperMediator.instance().getMainPane().setCompilerMode();
                }
                if (event.getSource() == AopHelperMenuBar.this.run) {
                    AopHelperMediator.instance().getMainPane().setRunMode();
                }
            }
        };
        this.compile.addActionListener(menuListener);
        this.run.addActionListener(menuListener);
        exit.addActionListener(menuListener);
        return fileMenu;
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenuItem save = new JMenuItem("Save settings", 83);
        save.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AopHelperMediator.instance().saveSettings();
            }
        });
        editMenu.add(save);
        JMenuItem load = new JMenuItem("Load settings", 76);
        load.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AopHelperMediator.instance().loadSettings();
            }
        });
        editMenu.add(load);
        return editMenu;
    }

    public void setCompileMode() {
        this.compile.setEnabled(false);
        this.run.setEnabled(true);
    }

    public void setRunMode() {
        this.run.setEnabled(false);
        this.compile.setEnabled(true);
    }
}

