/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aophelper.util;

import java.io.File;
import java.io.IOException;
import org.jboss.aophelper.core.AopCompile;
import org.jboss.aophelper.core.AopHandler;
import org.jboss.aophelper.util.CommandUtil;

public class AopCompileCommand {
    public String[] execute() {
        String execute = this.setup();
        try {
            String[] emptyArray = new String[]{};
            Process process = Runtime.getRuntime().exec(execute, emptyArray, new File(AopHandler.instance().getCompile().getWorkingdir()));
            return CommandUtil.analyzeProcess(process);
        }
        catch (IOException ie) {
            System.out.println("Error while aopcompiling: " + ie.getMessage());
            ie.printStackTrace();
            return null;
        }
    }

    private String setup() {
        AopCompile compileOptions = AopHandler.instance().getCompile();
        StringBuilder execute = new StringBuilder();
        execute.append("java -cp ").append(this.getClasspath());
        execute.append(" org.jboss.aop.standalone.Compiler ");
        if (compileOptions.isVerbose()) {
            execute.append("-verbose ");
        }
        if (compileOptions.isNoopt()) {
            execute.append("-noopt ");
        }
        if (compileOptions.isSuppress()) {
            execute.append("-suppress ");
        }
        if (compileOptions.getAopXml().size() > 0) {
            execute.append("-aoppath ");
            String pathSep = System.getProperty("path.separator");
            StringBuffer xmlPaths = new StringBuffer();
            for (String xml : compileOptions.getAopXml()) {
                if (xmlPaths.length() > 0) {
                    xmlPaths.append(pathSep);
                }
                System.out.println("appending xml: " + xml);
                xmlPaths.append(xml);
            }
            execute.append(xmlPaths.toString()).append(" ");
        }
        execute.append(compileOptions.getWorkingdir());
        System.out.println("EXECUTING: " + execute.toString());
        return execute.toString();
    }

    private String getClasspath() {
        StringBuilder sb = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator");
        for (String path : AopHandler.instance().getCompile().getClasspath()) {
            if (sb.length() > 0) {
                sb.append(pathSeparator);
            }
            sb.append(path);
        }
        if (sb.length() > 0) {
            sb.append(pathSeparator);
        }
        sb.append(AopHandler.instance().getCompile().getWorkingdir());
        return sb.toString();
    }
}

